<?php

/* get featured products */
$has_featured = FALSE;

// get featured category
$featured_category = $wpdb->get_var('SELECT id FROM '. WPSC_TABLE_PRODUCT_CATEGORIES . ' WHERE `nice-name` = "featured" LIMIT 1');
if($featured_category != null)
{
	$wpsc_query = new WPSC_Query(array('category_id' => $featured_category));
	$has_featured = TRUE;
}

get_header(); ?>

<script type="text/javascript" charset="utf-8">
/* <![CDATA[ */
stepcarousel.setup({
	galleryid: 'featured-products',
	beltclass: 'featured-belt', 
	panelclass: 'featured-wrap',
	panelbehavior: {speed:300, wraparound:true, persist:true},
	defaultbuttons: {enable: false},
	contenttype: ['inline']
});
stepcarousel.setup({
	galleryid: 'newest-products',
	beltclass: 'newest-belt', 
	panelclass: 'newest-panel',
	panelbehavior: {speed:300, wraparound:true, persist:true},
	defaultbuttons: {enable: false},
	contenttype: ['inline']
});
/* ]]> */
</script>
		<div id="featured" class="container">
			<div class="content">
				<h3 id="featured-banner"><?php _e('Featured Products'); ?></h3>
				<a class="prev prev1" href="javascript:stepcarousel.stepBy('featured-products', -1)"><?php _e('Previous'); ?></a>
				<div id="featured-products" class="featured-scrollable">
					<div class="featured-belt">
					<?php if ($has_featured) : ?>
						<?php while (wpsc_have_products()) :  wpsc_the_product(); ?>
							<div class="featured-wrap">
								<div class="featured-text">
									<h4 class="featured-name">
										<?php if(get_option('hide_name_link') == 1) : ?>
											<span><?php echo wpsc_the_product_title(); ?></span>
										<?php else: ?> 
											<a href="<?php echo wpsc_the_product_permalink(); ?>"><?php echo wpsc_the_product_title(); ?></a>
										<?php endif; ?>
									</h4>
									<div class="featured-description">
										<?php echo wpsc_the_product_description(); ?>
									</div>
									<div class="featured-more more">
										<a title="<?php _e('More Information'); ?>" href="<?php echo wpsc_the_product_permalink(); ?>"><?php _e('more information'); ?></a>
									</div>
								</div><!-- .featured-text -->
								<?php $product_picture = get_product_meta(wpsc_the_product_id(), 'product_picture'); ?>
								<?php if($product_picture != '') : ?>
								<div class="featured-image">
									<img alt="<?php echo wpsc_the_product_title(); ?>" src="<?php bloginfo('stylesheet_directory'); ?>/libraries/timthumb.php?w=420&src=<?php echo urlencode($product_picture); ?>" />
								</div><!-- .featured-image -->
								<?php endif; ?>
							</div><!-- .featured-wrap -->
						<?php endwhile; ?>
						<?php endif; ?>
					</div><!-- .featured-belt -->
				</div><!-- .featured-scrollable -->
				<a class="next next1" href="javascript:stepcarousel.stepBy('featured-products', 1)"><?php _e('Next'); ?></a>
			</div><!-- .content -->
		</div><!-- .container -->
		
		<?php
		/* get newest products */
		$has_new = FALSE;

		// get newest category
		$newest_category = $wpdb->get_var('SELECT id FROM '. WPSC_TABLE_PRODUCT_CATEGORIES . ' WHERE `nice-name` = "newest" LIMIT 1');
		if($newest_category != null)
		{
			$wpsc_query = new WPSC_Query(array('category_id' => $newest_category));
			$has_new = TRUE;
		}
		?>
		
		<div id="newest" class="container">
			<div class="content">
				<?php if ($has_new) : ?>
				<a class="prev prev2" href="javascript:stepcarousel.stepBy('newest-products', -4)"><?php _e('Previous'); ?></a>
				<div id="newest-products" class="newest-scrollable">
					<div class="newest-belt">
						<div class="newest-wrap">
							<?php while (wpsc_have_products()) :  wpsc_the_product(); ?>
							<div class="newest-panel">
								<?php if(get_option('show_thumbnails')) :?>
								<div class="newest-image">
									<?php $product_image = wpsc_the_product_image(); ?>
									<?php if($product_image != '') :?>
										<img id="product_image_<?php echo wpsc_the_product_id(); ?>" alt="<?php echo wpsc_the_product_title(); ?>" title="<?php echo wpsc_the_product_title(); ?>" src="<?php bloginfo('stylesheet_directory'); ?>/libraries/timthumb.php?w=180&h=160&src=<?php echo urlencode($product_image); ?>" />
									<?php else: ?>
										<span>No Image Available</span>
									<?php endif; ?>
								</div><!-- .newest-image -->
								<?php endif; ?>
								<h5>
									<?php $p_title = wpsc_the_product_title(); ?>
									<?php $p_title = (strlen($p_title) > 20) ? substr($p_title, 0, 20) . '...' : $p_title; ?>
									<?php if(get_option('hide_name_link') == 1) : ?>
										<span><?php echo $p_title; ?></span>
									<?php else: ?> 
										<a href="<?php echo wpsc_the_product_permalink(); ?>"><?php echo $p_title; ?></a>
									<?php endif; ?>
								</h5>
								<div class="newest-cat">
									<p>
										<?php echo $icl_utility->output_get_categories(wpsc_the_product_id(), ', ', '<a href="%s">', '</a>'); ?>
									</p>
									<p>
										<?php if(wpsc_product_is_donation()) : ?>
										<?php else : ?>
											<?php if(wpsc_product_on_special()) : ?>
												<span style="text-decoration:line-through;"><?php echo wpsc_product_normal_price(); ?></span>
											<?php endif; ?>
											<?php echo wpsc_the_product_price(); ?>
										<?php endif; ?>
									</p>
								</div>
								<div class="newest-desc">
									<?php echo wpsc_the_product_description(); ?>
								</div>
								<p class="more">
									<a href="<?php echo wpsc_the_product_permalink(); ?>"><?php _e('more information'); ?></a>
								</p>
							</div><!-- .newest-panel -->
							<?php endwhile; ?>
						</div><!-- .newest-wrap -->
					</div><!-- .newest-belt -->
				</div><!-- #newest-products -->
				<a class="next next2" href="javascript:stepcarousel.stepBy('newest-products', 4)"><?php _e('Next'); ?></a>
				<?php endif; ?>
			</div><!-- .content -->
		</div><!-- .container -->

<?php get_footer(); ?>