<?php
/**
 * @package WordPress
 * @subpackage Kelontong
 */

global $icl_utility, $wpsc_query, $wpdb, $featured_category, $current_product_id;

// get featured category
if (!isset($featured_category))
{
	$featured_category = $wpdb->get_var('SELECT id FROM '. WPSC_TABLE_PRODUCT_CATEGORIES . ' WHERE `nice-name` = "featured" LIMIT 1');
}

// get random featured product
if ($featured_category != null)
{
	$sql = 'SELECT ' . WPSC_TABLE_PRODUCT_LIST . '.id, name, LEFT(description, 80) as description, price, pnp, file, image, special, special_price ';
	$sql .= 'FROM ' . WPSC_TABLE_PRODUCT_LIST . ' LEFT JOIN ' . WPSC_TABLE_ITEM_CATEGORY_ASSOC . ' ON ';
	$sql .= WPSC_TABLE_PRODUCT_LIST . '.id = ' . WPSC_TABLE_ITEM_CATEGORY_ASSOC . '.product_id ';
	$sql .= 'WHERE publish = 1 AND active = 1 AND ' . WPSC_TABLE_ITEM_CATEGORY_ASSOC . '.category_id = ' . $featured_category . ' ';
	if ($current_product_id != '')
	{
		$sql .= 'AND ' . WPSC_TABLE_PRODUCT_LIST . '.id != ' . $current_product_id . ' ';
	}
	$sql .= 'ORDER BY RAND() LIMIT 1';
	
	$wpsc_query->products = $wpdb->get_results($sql, ARRAY_A);
	$wpsc_query->product_count = count($wpsc_query->products);
}
?>
	<div id="left-column">
		<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar() ) : ?>
		<?php endif; ?>
		<div class="sidebar">
			<h4><?php _e('Search'); ?></h4>
			<div id="search">
			<?php get_search_form(); ?>
			</div><!-- #search -->
		</div><!-- .side -->
		<div class="sidebar">
			<h4><?php _e('Featured Product'); ?></h4>
			<div id="featured-side">
				<?php while (wpsc_have_products()) :  wpsc_the_product(); ?>
				<?php if(get_option('show_thumbnails')) :?>
				<div class="featured-side-image">
				<?php $product_image = wpsc_the_product_image(); ?>
				<?php if($product_image != '') :?>
					<a href="<?php echo wpsc_the_product_permalink(); ?>">
						<img id="featured_product_image_<?php echo wpsc_the_product_id(); ?>" alt="<?php echo wpsc_the_product_title(); ?>" title="<?php echo wpsc_the_product_title(); ?>" src="<?php bloginfo('stylesheet_directory'); ?>/libraries/timthumb.php?w=128&src=<?php echo urlencode($product_image); ?>" />
					</a>
				<?php else: ?>
					<span>No Image Available</span>
				<?php endif; ?>
				</div><!-- .featured-side-image -->
				<?php endif; ?>
				<div class="featured-side-desc">
					<h5>
					<?php if(get_option('hide_name_link') == 1) : ?>
						<span><?php echo wpsc_the_product_title(); ?></span>
					<?php else: ?> 
						<a href="<?php echo wpsc_the_product_permalink(); ?>"><?php echo wpsc_the_product_title(); ?></a>
					<?php endif; ?>
					</h5>
					<p class="featured-side-category">
						<?php echo $icl_utility->output_get_categories(wpsc_the_product_id(), ', ', '<a href="%s">', '</a>'); ?>
					</p><!-- .featured-side-category -->
					<p class="featured-side-price">
						<?php if(wpsc_product_is_donation()) : ?>
						<?php else : ?>
							<?php if(wpsc_product_on_special()) : ?>
								<span style="text-decoration:line-through;"><?php echo wpsc_product_normal_price(); ?></span>
							<?php endif; ?>
							<?php echo wpsc_the_product_price(); ?>
						<?php endif; ?>
					</p><!-- .featured-side-price -->
					<p class="featured-side-description">
						<?php if ($wpsc_query->product['simple_description'] != '') : ?>
						<?php echo $wpsc_query->product['simple_description']; ?>
						<?php endif;?>
					</p><!-- .featured-side-description -->
					<div class="featured-more more">
						<a href="<?php echo wpsc_the_product_permalink(); ?>"><?php _e('More Information'); ?></a>
					</div>
				</div><!-- .featured-side-desc -->
				<?php endwhile; ?>
			</div><!-- #featured-side -->
		</div><!-- .side -->
<?php
$has_popular = FALSE;
$popular_sql = $icl_utility->get_sql_top_selling(array(), 5);
if ($popular_sql != '')
{
	$wpsc_query->products = $wpdb->get_results($popular_sql, ARRAY_A);
	$wpsc_query->product_count = count($wpsc_query->products);
	$has_popular = TRUE;
}
?>
		<?php if ($has_popular) : ?>
		<div class="sidebar">
			<h4><?php _e('Popular Products'); ?></h4>
			<div id="popular-side" class="blocked-sidebar">
				<ul>
				<?php while (wpsc_have_products()) :  wpsc_the_product(); ?>
					<li>
						<?php if(get_option('show_thumbnails')) :?>
						<?php $product_image = wpsc_the_product_image(); ?>
						<?php if($product_image != '') :?>
							<a href="#">
								<img id="download_product_image_<?php echo wpsc_the_product_id(); ?>" alt="<?php echo wpsc_the_product_title(); ?>" title="<?php echo wpsc_the_product_title(); ?>" src="<?php bloginfo('stylesheet_directory'); ?>/libraries/timthumb.php?w61=&h=53&src=<?php echo urlencode($product_image); ?>" />
							</a>
						<?php else: ?>
							<span>No Image Available</span>
						<?php endif; ?>
						<?php endif; ?>
						<h5>
							<?php $p_title = wpsc_the_product_title(); ?>
							<?php $p_title = (strlen($p_title) > 15) ? substr($p_title, 0, 15) . '...' : $p_title; ?>
							<?php if(get_option('hide_name_link') == 1) : ?>
								<span><?php echo  $p_title; ?></span>
							<?php else: ?> 
								<a href="<?php echo wpsc_the_product_permalink(); ?>" title="<?php echo wpsc_the_product_title(); ?>"><?php echo  $p_title; ?></a>
							<?php endif; ?>
						</h5>
						<?php echo $icl_utility->output_get_categories(wpsc_the_product_id(), ', ', '<a href="%s">', '</a>'); ?>
						<div class="clear"></div>
					</li>
				<?php endwhile; ?>
				</ul>
			</div>
		</div><!-- .side -->
		<?php endif; ?>
	</div><!-- #left-column -->