<?php
	$query_string = '&'.urldecode($query_string);
	
	$current_page = $icl_utility->stripNonText($icl_utility->extractArgument('&'.$query_string, 'pagename'));
	
	get_header();
	
	$show_full_page = TRUE;
	
	if (preg_match("/products-page/i", $current_page))
	{
		$show_full_page = FALSE;
		if (preg_match("/your-account/i", $current_page))
		{
			$show_full_page = TRUE;
		}
	}
	
	if (defined('WPSC_TABLE_PRODUCT_LIST'))
	{
		if ($show_full_page)
		{
			$i_product = 1;
			$limit = 10;
			
			$sql = 'SELECT id, image ';
			$sql .= 'FROM ' . WPSC_TABLE_PRODUCT_LIST .' ';
			$sql .= 'WHERE publish = 1 AND active = 1 ';
			$sql .= 'ORDER BY RAND() LIMIT ' . $limit;
			
			$wpsc_query->products = $wpdb->get_results($sql, ARRAY_A);
			$wpsc_query->product_count = count($wpsc_query->products);
		}
	}
?>
	
	<?php if ($show_full_page) : ?>
	<div id="one-column" class="container">
		<div class="content">
			<div class="random">
				<ul>
					<?php if (function_exists('wpsc_have_products')) : ?>
					<?php while (wpsc_have_products()) :  wpsc_the_product(); ?>
					<li<?php if($i_product == $limit) :?> class="no"<?php endif; ?>>
						<a href="<?php echo wpsc_the_product_permalink(); ?>">
						<?php if(get_option('show_thumbnails')) :?>
						<?php $product_image = wpsc_the_product_image(); ?>
						<?php if($product_image != '') :?>
							<img alt="<?php echo wpsc_the_product_title(); ?>" title="<?php echo wpsc_the_product_title(); ?>" src="<?php bloginfo('stylesheet_directory'); ?>/libraries/timthumb.php?w=60&h=60&src=<?php echo urlencode($product_image); ?>" width="60" height="60" />
						<?php else: ?>
							<span>No Image Available</span>
						<?php endif; ?>
						<?php endif; ?>
						</a>
					</li>
					<?php ++$i_product; ?>
					<?php endwhile; ?>
					<?php endif; ?>
				</ul>
			</div>
			<div class="post-content">
			<?php if (have_posts()) : ?>
				<h3><?php the_title(); ?></h3>
				<?php while (have_posts()) : the_post(); ?>
					<?php the_content("Continue reading&hellip;"); ?>
					<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
				<?php endwhile; ?>
			<?php else : ?>
				<?php /* Error 404 */ ?>	
				<?php $filename = TEMPLATEPATH . '/404.php'; if (file_exists($filename)) { include($filename); } ?>
			<?php endif; ?>
			</div>
		</div>
	</div>
	<?php else : ?>
	<div id="two-columns" class="container">
		<div class="content">
			<div id="right-column">
				<script type="text/javascript" charset="utf-8">
				/* <![CDATA[ */
				function setEqualHeight(columns) {
					var tallestcolumn = 0;
					columns.each(
						function() {
							currentHeight = jQuery(this).height();
							if(currentHeight > tallestcolumn) {
								tallestcolumn  = currentHeight;
							}
						}
					);
					columns.css('min-height', tallestcolumn);
					delete tallestcolumn;
				}

				jQuery(document).ready(function() {
					setEqualHeight(jQuery(".wrapin  > div"));
				});
				/* ]]> */
				</script>
				<?php if (have_posts()) : ?>
					<?php while (have_posts()) : the_post(); ?>
						<?php the_content("Continue reading&hellip;"); ?>
					<?php endwhile; ?>
				<?php else : ?>
					<?php /* Error 404 */ ?>	
					<?php $filename = TEMPLATEPATH . '/404.php'; if (file_exists($filename)) { include($filename); } ?>
				<?php endif; ?>
			</div><!-- #right-column -->
			<?php get_sidebar(); ?>
			<div class="clear"></div>
		</div><!-- .content -->
	</div><!-- #two-columns -->
	<?php endif; ?>

<?php get_footer(); ?>