from rdflib import URIRef, RDF, RDFS, Literal
from rdflib.namespace import SKOS
from kombu import Queue
from environs import Env

env = Env()
env.read_env()  # read .env file, if it exists
# Debug and running settings

HOST = "0.0.0.0"
DEBUG = env.bool("DEBUG", True)

SERVER_NAME = "catedit.iri-research.org"
BASE_URL = env.str("BASE_URL", "https://catedit.iri-research.org")

# WTForms settings

SECRET_KEY = env.str("SECRET_KEY")

LOGGING_CONFIG = {
    "IS_LOGGING": True,
    "LOGGING_LEVEL": "DEBUG",
    "LOG_FILE_PATH": "-",
}

CACHE_CONFIG = {
    "CACHE_TYPE": "memcached",
    "CACHE_KEY_PREFIX": "ctdt",
    "CACHE_MEMCACHED_SERVERS" : (env.str('MEMCACHED_URL'),),
}

# Github repository config
PERSISTENCE_CONFIG = {
    "METHOD" : "PersistenceToGithub",
    "REPOSITORY_LIST" : [
        "catedit-dev-testing",
        "mons-categories-prototype",
        "habitabilite-prototype",
        "collaboration-prototype",
        "economie-de-la-contribution",
        "habitabilite-chercheur",
        "explorunivers-habitabilite",
        "catedit-testing",
    ],
    "REPOSITORY_OWNER" : "catedit-system",
    "CATEGORIES_PATH" : "categories/",
    "GITHUB_CLIENT_ID" : env.str("GITHUB_CLIENT_ID"),
    "GITHUB_CLIENT_SECRET" : env.str("GITHUB_CLIENT_SECRET")
}

# Property List
PROPERTY_LIST = {
    RDFS.subClassOf.toPython(): {
        "descriptive_label_fr": "Sous-classe de",
        "descriptive_label_en": "Subclass of",
        "object_type": "uriref-category",
        "usable_in_editor": True,
        "rdflib_class": RDFS.subClassOf,
    },
    RDFS.comment.toPython(): {
        "descriptive_label_fr": "Commentaire",
        "descriptive_label_en": "Comment",
        "object_type": "literal",
        "usable_in_editor": True,
        "rdflib_class": RDFS.comment,
    },
    RDFS.Resource.toPython(): {
        "descriptive_label_fr": "Ressource",
        "descriptive_label_en": "Resource",
        "object_type": "uriref-link",
        "usable_in_editor": True,
        "rdflib_class": RDFS.Resource,
    },
    SKOS.related.toPython(): {
        "descriptive_label_fr": "En relation avec",
        "descriptive_label_en": "Related to",
        "object_type": "uriref-category",
        "usable_in_editor": True,
        "rdflib_class": SKOS.related,
    }
}


CELERY_BROKER_URL = env.str('BROKER_URL')
CELERY_RESULT_BACKEND = env.str('RESULT_BROKER_URL')
if PERSISTENCE_CONFIG["METHOD"] == "PersistenceToGithub":
    CELERY_QUEUES = tuple(
        Queue("repo_"+repository, routing_key="task_for_"+repository) for repository in PERSISTENCE_CONFIG["REPOSITORY_LIST"]
    )
