# set base image (host OS)
FROM docker.io/python:alpine as base

ARG DEV=false
ENV PATH="/code/.venv/bin:$PATH"
WORKDIR /code

FROM base as builder

ENV POETRY_NO_INTERACTION=1 \
    POETRY_VIRTUALENVS_IN_PROJECT=1 \
    POETRY_VIRTUALENVS_CREATE=1 \
    POETRY_CACHE_DIR=/tmp/poetry_cache

RUN \
  apk add --no-cache libmemcached zlib && \
  apk add --no-cache musl-dev build-base libmemcached-dev zlib-dev linux-headers


# Install Poetry
RUN pip install poetry

# Install the app
COPY src/pyproject.toml src/poetry.lock ./
RUN if [ $DEV ]; then \
      poetry install --with dev --no-root && rm -rf $POETRY_CACHE_DIR; \
    else \
      poetry install --without dev --no-root && rm -rf $POETRY_CACHE_DIR; \
    fi

FROM base as runtime

RUN apk add --no-cache libmemcached zlib bash

COPY --from=builder /code/.venv /code/.venv
COPY src/catedit /code/catedit
COPY docker/catedit.yml /code/
COPY docker/config.py /code/
ENV CATEDIT_SETTINGS=/code/config.py
  

CMD ["uwsgi", "--yaml", "/code/catedit.yml"]