"""
meta.py:
the views that provide meta actions on the system
"""

from celery.result import AsyncResult
from celery.states import SUCCESS, FAILURE, REVOKED
from flask import Blueprint, session, jsonify, request

from catedit import app, cache, celery, csrf
from catedit.views import utils

meta = Blueprint('meta', __name__)
logger = app.logger


@csrf.exempt
@meta.route('/cache-clear', defaults={'registry_key': None}, methods=["POST"])
@meta.route('/cache-clear/<string:registry_key>', methods=["POST"])
def cache_clear_endpoint(registry_key):
    if not cache_keys:
        cache.clear()
    else:
        if cache.get(registry_key) is not None:
            for key in cache.get(registry_key):
                if cache.get(key) is not None:
                    cache.delete(key)
            cache.delete(registry_key)
    return ('', 204)


@meta.route('/query-tasks-status/<string:repository>', defaults={'task_ids': None}, methods=["GET"])
@meta.route('/query-tasks-status/<string:repository>/<string:task_ids>', methods=["GET"])
def query_tasks_status(repository, task_ids=None):

    if not task_ids:
        task_ids_list = session.get('tasks', {}).get(repository, [])
    else:
        task_ids_list = task_ids.split(',')


    res = utils.get_tasks_status(task_ids_list, not task_ids, repository)

    return jsonify(**res)

@meta.route('/help', methods = ['GET'])
def help():
    """Print available functions."""
    func_list = {}
    for rule in app.url_map.iter_rules():
        if rule.endpoint != 'static':
            func_list[rule.rule] = app.view_functions[rule.endpoint].__doc__
    return jsonify(func_list)

@app.context_processor
def inject_running_tasks():
    if 'repository' in request.view_args:
        repository = request.view_args['repository']
        task_ids_list = session.get('tasks', {}).get(repository, [])
        if task_ids_list:
            tasks_status = utils.get_tasks_status(task_ids_list, True, repository)
            return {'running_tasks_nb': tasks_status.get('running_tasks_nb',0)}
        else:
            return {'running_tasks_nb': 0}
    else:
        return {}
