"""
forms.py
Module that groups custom forms used in CatEdit
"""
from flask_wtf import Form
from wtforms import StringField, TextAreaField, FormField, \
                    FieldList, HiddenField
from wtforms.validators import DataRequired, Optional


class CommitForm(Form):
    """
        Custom form class for commiting changes
    """
    commit_message = StringField(
        "Message de soumission (obligatoire)",
        validators=[DataRequired()]
    )


class PropertyForm(Form):
    """
        Form of a given property, each one is a couple of hidden fields that
        can be Javascript-generated in the template
    """
    property_predicate = HiddenField()
    property_object = HiddenField(
        validators=[DataRequired()]
    )


class CategoryForm(Form):
    """
        Custom form class for creating a category with the absolute minimal
        attributes (label and description)
    """
    label = StringField(
        "Nom de la categorie (obligatoire)",
        validators=[DataRequired()]
    )
    description = TextAreaField(
        "Description de la categorie (obligatoire)",
        validators=[DataRequired()]
    )
    properties = FieldList(FormField(PropertyForm), validators=[Optional()])


class CommentForm(Form):
    """
        Custom form class for commiting changes
    """
    comment_field = TextAreaField(
        "Poster un commentaire: ",
        validators=[DataRequired()]
    )

class NewDiscussionForm(Form):
    """
        Custom form class for commiting changes
    """
    discussion_title = StringField(
        "Titre de la discussion: ",
        validators=[DataRequired()]
    )
    comment_field = TextAreaField(
        "Commentaire d'ouverture (facultatif): "
    )