from flask.ext.restful import Resource, fields, Api, reqparse
from flask import request
from app import app
from models import Category, CategoryManager
from rdflib import Graph, RDF
from utils import *
from settings import *
from config import *
import os

api = Api(app)

cat_parser=reqparse.RequestParser()
cat_parser.add_argument('label', type=str)
cat_parser.add_argument('description', type=str)
cat_parser.add_argument('commit_message', type=str)
cat_parser.add_argument('property_predicate', type=str, action="append")
cat_parser.add_argument('property_object', type=str, action="append")


class CategoryAPI(Resource):
    # returns category cat_id
    def get(self, cat_id=None):
        # load file cat_id
        # TODO: load list if cat_id=None
        cat_manager_instance = CategoryManager()
        if cat_id is not None:
            c = cat_manager_instance.load_cat(cat_id)
            return c.cat_graph.serialize(format='turtle')
        else:
            response=[]
            for c in cat_manager_instance.list_cat():
                response.append(c.cat_graph.serialize(format='turtle'))
            return response

    # update category cat_id
    def put(self, cat_id):
        args = cat_parser.parse_args()
        cat_manager_instance = CategoryManager()

        new_property_list=[]
        # print args["property_predicate"]
        # print args["property_object"]
        for property_predicate, property_object in zip(
                args["property_predicate"],
                args["property_object"]):
            if property_object:
                new_property_list.append((property_predicate, property_object))
        # print new_property_list
        c = cat_manager_instance.load_cat(cat_id)
        c.edit_category(new_description=args["description"],
                        new_label=args["label"],
                        new_other_properties=new_property_list)
        cat_manager_instance.save_cat(c, message=args["commit_message"])
        return c.cat_graph.serialize(format='turtle'), 200
        # Maybe not send the whole cat back, see if it's worth it

    def post(self):
        args = cat_parser.parse_args()
        property_list = []
        print args["property_predicate"]
        print args["property_object"]
        for property_predicate, property_object in zip(
                request.form.getlist('property_predicate'),
                request.form.getlist('property_object')):
            if property_object:
                property_list.append((property_predicate, property_object))
        c = Category(label=args["label"],
                     description=args["description"],
                     other_properties=property_list)
        cat_manager_instance = CategoryManager()
        cat_manager_instance.save_cat(c, message=args["commit_message"])
        return c.cat_graph.serialize(format='turtle'), 201

    def delete(self, cat_id):
        cat_manager_instance = CategoryManager()
        cat_manager_instance.delete_cat(cat_id)
        return 204

api.add_resource(CategoryAPI,
                 '/category/<string:cat_id>',
                 '/category',
                 endpoint='category')
