"""
__init__.py:
module main file used to configure the Flask app
"""

from logging import FileHandler, Formatter
import os

from flask import Flask, session
from flask.ext.github import GitHub
from flask.ext.cache import Cache
from flask.ext.restful import Api

from catedit.settings import AppSettings

# set up app and database
app = Flask(__name__)
app.config.from_object(AppSettings)
cache = Cache(app, config={"CACHE_TYPE": "simple"})
app_configured = False
try:
    from catedit.config import AppConfig
    app.config.from_object(AppConfig)
    app_configured = True
except ImportError:
    pass

if 'CATEDIT_SETTINGS' in os.environ:
    app.config.from_envvar('CATEDIT_SETTINGS')
    app_configured = True

if not app_configured:
    raise Exception("Catedit not configured")

#github
github = GitHub(app)

#api
api = Api(app)


#views
from catedit.views import cat_editor, cat_recap, github_login,\
                          github_callback, logout

from catedit.resources import CategoryAPI, CategoryChangesAPI


api.add_resource(CategoryAPI,
                 '/category/<string:cat_id>',
                 '/category',
                 endpoint='category')
api.add_resource(CategoryChangesAPI,
                 '/category-changes/<string:cat_id>',
                 '/category-changes',
                 endpoint='category_changes')


# set up logging
if app.config["LOGGING"]:
    file_handler = FileHandler(filename=app.config["LOG_FILE_PATH"])
    file_handler.setFormatter(Formatter(
        '%(asctime)s %(levelname)s: %(message)s '
        '[in %(pathname)s:%(lineno)d]',
        '%Y-%m-%d %H:%M:%S'
    ))
    app.logger.addHandler(file_handler)
    app.logger.setLevel(app.config["LOGGING_LEVEL"])

# session management

app.secret_key = app.config["SECRET_KEY"]
