from flask.ext.restful import abort
from models import Category, CategoryManager
from rdflib.compare import *

'''
    This function will compare two categories from their Graph object
    serializations.
    Exact return values are to be defined, some ideas
    * check if the 2 categories are the same? (same ID, isomorphic)
    * check if the 2 categories are the same but different version?
      (same ID, not isomorphic)
    * check if unique, non empty parameters changed and list them
      (label and description)
    * returns 2 lists of properties: only_in_first, only_in_second
    * more?
'''


def compare_two_cat(cat_serial_1, cat_serial_2):
    cat1 = Category(cat_serial_1)
    cat2 = Category(cat_serial_2)
    iso_cat1 = cat1.cat_graph.to_isomorphic()
    iso_cat2 = cat2.cat_graph.to_isomorphic()
    if iso_cat1 != iso_cat2:
        in_both_cats, only_in_cat1, only_in_cat2 = graph_diff(cat1, cat2)
    return
