class sysconfig::sys_upgrade {

  exec {
    'apt_source_update':
      command   => "echo 'deb http://apt.postgresql.org/pub/repos/apt/ trusty-pgdg main dependencies' > /etc/apt/sources.list.d/pgdg.list;,
                    wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | apt-key add -;",
      timeout   => 0,
      provider  => 'shell',
      returns   => [0, 100];
    'apt_get_update_sysconfig':
      command     => '/usr/bin/apt-get update',
      timeout     => 2400,
      returns     => [ 0, 100 ],
#     refreshonly => true;
      require     => Exec['apt_source_update'];
    'sys-upgrade':
      command   => '/usr/bin/apt-get upgrade -y',
      timeout => 0,
      require   => Exec['apt_get_update_sysconfig'];
    'sys-dist-upgrade':
      command   => '/usr/bin/apt-get dist-upgrade -y',
      timeout => 0,
      require   => Exec['apt_get_update_sysconfig'];
  }

  Exec['apt_get_update_sysconfig'] -> Exec['sys-upgrade'] -> Exec['sys-dist-upgrade']
  
}
