"""
    version.py:
    Module to get the current CatEdit version, the only place where we have to
    increment version numbers
"""

__all__ = ["VERSION", "get_version", "CURRENT_VERSION"]

VERSION = (0, 1, 6)

def get_version():
    """
        Function to convert the tuple to a string
    """
    version = "%s.%s" % (VERSION[0], VERSION[1])
    if version[2]:
        version = "%s.%s" % (version, VERSION[2])
    return version

CURRENT_VERSION = get_version()
