"""
__init__.py:
module main file used to configure the Flask app
"""

from logging import FileHandler, Formatter

from flask import Flask, session
from flask.ext.github import GitHub
from flask.ext.cache import Cache
from flask.ext.restful import Api

from catedit.config import AppConfig
from catedit.settings import AppSettings

# set up app and database
app = Flask(__name__)
app.config.from_object(AppSettings)
cache = Cache(app, config={"CACHE_TYPE": "simple"})
app.config.from_object(AppConfig)

#github
github = GitHub(app)

#api
api = Api(app)


#views
from catedit.views import cat_editor, cat_recap, github_login,\
                          github_callback, logout

from catedit.resources import CategoryAPI, CategoryChangesAPI


api.add_resource(CategoryAPI,
                 '/category/<string:cat_id>',
                 '/category',
                 endpoint='category')
api.add_resource(CategoryChangesAPI,
                 '/category-changes/<string:cat_id>',
                 '/category-changes',
                 endpoint='category_changes')


# set up logging
if app.config["LOGGING"]:
    file_handler = FileHandler(filename=app.config["LOG_FILE_PATH"])
    file_handler.setFormatter(Formatter('''
    Message type:       %(levelname)s
    Location:           %(pathname)s:%(lineno)d
    Module:             %(module)s
    Function:           %(funcName)s
    Time:               %(asctime)s

    Message:

    %(message)s
    '''))
    app.logger.addHandler(file_handler)
    app.logger.setLevel(app.config["LOGGING_LEVEL"])

# session management

app.secret_key = app.config["SECRET_KEY"]
