from catedit import app, celery, cache
from catedit.models import CategoryManager
import catedit.persistence
import logging

from flask import g, url_for
import requests


logger = logging.getLogger(__name__)

@celery.task
def submit_changes(modified_categories, deleted_categories, message, repository, token):
    with app.app_context():
        g.user_code = token
        cat_manager_instance = CategoryManager(
            getattr(
                catedit.persistence,
                app.config["PERSISTENCE_CONFIG"]["METHOD"]
            )(repository=repository),
        )

        if cat_manager_instance.persistence.session_compliant is True:
            cat_manager_instance.save_changes(
                deleted_cat_dict=deleted_categories,
                modified_cat_dict=modified_categories,
                message=message
            )
            #registry_key = "categories_"+repository+"_keys"
            #r = requests.post(app.config['BASE_URL']+"/meta/cache-clear/"+registry_key)
            r = requests.post(app.config['BASE_URL']+"/meta/cache-clear")
            try:
                r.raise_for_status()
            except:
                logger.exception("Error when clearing cache.")
                pass
