from flask import Flask, session
from flask.ext.github import GitHub
from flask.ext.cache import Cache
from settings import *
from config import *
from logging import *

# set up app and database
app = Flask(__name__)
app.config.from_object(appSettings)
cache = Cache(app, config={"CACHE_TYPE": "simple"})
app.config.from_object(appConfig)

github = GitHub(app)

# set up logging
if app.config["LOGGING"]:
    file_handler = FileHandler(filename=app.config["LOG_FILE_PATH"])
    file_handler.setFormatter(Formatter('''
    Message type:       %(levelname)s
    Location:           %(pathname)s:%(lineno)d
    Module:             %(module)s
    Function:           %(funcName)s
    Time:               %(asctime)s

    Message:

    %(message)s
    '''))
    app.logger.addHandler(file_handler)
    app.logger.setLevel(app.config["LOGGING_LEVEL"])

# session management

app.secret_key = "extremely_secure_and_very_secret_key"
