from flask.ext.github import GitHubError
from abc import ABCMeta, abstractmethod
from app import app, github, session
from base64 import b64encode, b64decode
import os
import json


class Persistence:
    __metaclass__ = ABCMeta

    @abstractmethod
    def save(self, **kwargs):
        return

    @abstractmethod
    def delete(self, **kwargs):
        return

    @abstractmethod
    def load(self, **kwargs):
        return

    @abstractmethod
    def list(self, **kwargs):
        return

"""
kwargs for saving to a file should be

pathDir = directory to save the file in
fileName = name of the file to write in
content = desired content of the file

There is still adjustments to do on this
"""


class PersistenceToFile(Persistence):
    def save(self, **kwargs):
        path_to_save = app.config["FILE_SAVE_DIRECTORY"]+kwargs["name"]
        file = open(path_to_save, 'w+')
        file.write(kwargs["content"])
        file.close()

    def load(self, **kwargs):
        path_to_load = app.config["FILE_SAVE_DIRECTORY"]+kwargs["name"]
        file = open(path_to_load, 'r')
        file_content = file.read()
        file.close()
        return file_content

    def delete(self, **kwargs):
        path_to_delete = app.config["FILE_SAVE_DIRECTORY"]+kwargs["name"]
        os.remove(path_to_delete)

    # IDEA: return { file_name: file_content } type dict
    def list(self, **kwargs):
        file_content_list = []
        for file_name in os.listdir(app.config["FILE_SAVE_DIRECTORY"]):
            file = open(app.config["FILE_SAVE_DIRECTORY"]+file_name)
            file_content = file.read()
            file.close
            file_content_list.append(file_content)
        # print file_content_list
        return file_content_list


class PersistenceToGithub(Persistence):
    def save(self, **kwargs):
        # print kwargs["content"]
        request_data = {"content": b64encode(kwargs["content"]),
                        "message": kwargs["message"]}
        try:
            filedict = github.get("repos/"
                                  + app.config["REPOSITORY_OWNER"]+"/"
                                  + app.config["REPOSITORY_NAME"]
                                  + "/contents/"
                                  + app.config["CATEGORIES_PATH"]
                                  + kwargs["name"])
            request_data["sha"] = filedict["sha"]
        except GitHubError:
            pass
        # print json.dumps(request_data)
        try:
            github.request('PUT',
                           "repos/"
                           + app.config["REPOSITORY_OWNER"]+"/"
                           + app.config["REPOSITORY_NAME"]
                           + "/contents/"
                           + app.config["CATEGORIES_PATH"]
                           + kwargs["name"],
                           data=json.dumps(request_data))
        except GitHubError:
            pass

    def load(self, **kwargs):
        try:
            filedict = github.get("repos/"
                                  + app.config["REPOSITORY_OWNER"]+"/"
                                  + app.config["REPOSITORY_NAME"]
                                  + "/contents/"
                                  + app.config["CATEGORIES_PATH"]
                                  + kwargs["name"])
            file_content = b64decode(filedict["content"])
        except GitHubError:
            pass
        return file_content

    def delete(self, **kwargs):
        request_data = {"message": kwargs["message"]}
        try:
            filedict = github.get("repos/"
                                  + app.config["REPOSITORY_OWNER"]+"/"
                                  + app.config["REPOSITORY_NAME"]
                                  + "/contents/"
                                  + app.config["CATEGORIES_PATH"]
                                  + kwargs["name"])
            request_data["sha"] = filedict["sha"]
        except GitHubError:
            pass

        try:
            github.request('DELETE',
                           "repos/catedit-system/"
                           + app.config["REPOSITORY_NAME"]
                           + "/contents/categories/"
                           + kwargs["name"],
                           data=json.dumps(request_data))
        except GitHubError:
            pass

    def list(self, **kwargs):
        filenames_list = []
        try:
            files_in_repo = github.get("repos/"
                                       + app.config["REPOSITORY_OWNER"]+"/"
                                       + app.config["REPOSITORY_NAME"]
                                       + "/contents/"
                                       + app.config["CATEGORIES_PATH"])
            filenames_list = [file["name"] for file in files_in_repo]
            # print filenames_list
        except GitHubError:
            pass
        file_content_list = []
        for filename in filenames_list:
            try:
                filedict = github.get("repos/"
                                      + app.config["REPOSITORY_OWNER"]+"/"
                                      + app.config["REPOSITORY_NAME"]
                                      + "/contents/"
                                      + app.config["CATEGORIES_PATH"]
                                      + filename)
                file_content_list.append(b64decode(filedict["content"]))
            except GitHubError:
                pass
        # print file_content_list
        return file_content_list
