from flask import Flask, session
from flask.ext.github import GitHub
from settings import *
from config import *
from logging import *

# set up app and database
app = Flask(__name__)
app.config.from_object(appSettings)
app.config.from_object(systemSettings)
# app.config['GITHUB_CLIENT_ID'] = LOCAL_APPLICATION_GITHUB_ID
# app.config['GITHUB_CLIENT_SECRET'] = LOCAL_APPLICATION_GITHUB_SECRET
github = GitHub(app)

# set up logging
file_handler=FileHandler(filename=app.config["LOG_FILE_PATH"])
file_handler.setFormatter(Formatter('''
Message type:       %(levelname)s
Location:           %(pathname)s:%(lineno)d
Module:             %(module)s
Function:           %(funcName)s
Time:               %(asctime)s

Message:

%(message)s
'''))
app.logger.addHandler(file_handler)

# session management

app.secret_key = "extremely_secure_and_very_secret_key"
