"""
meta.py:
the views that provide meta actions on the system
"""

from celery.result import AsyncResult
from celery.states import SUCCESS, FAILURE, REVOKED
from flask import Blueprint, session, jsonify, request

from catedit import app, cache, celery, csrf
from catedit.views import utils

meta = Blueprint('meta', __name__)
logger = app.logger


@csrf.exempt
@meta.route('/cache-clear', defaults={'cache_keys': None}, methods=["POST"])
@meta.route('/cache-clear/<cache_keys>', methods=["POST"])
def cache_clear_endpoint(cache_keys):
    if not cache_keys:
        cache.clear()
    else:
        cache_keys_list = cache_keys.split(",")
        cache.delete_many(*cache_keys_list)
    return ('', 204)


@meta.route('/query-tasks-status/<string:repository>', defaults={'task_ids': None}, methods=["GET"])
@meta.route('/query-tasks-status/<string:repository>/<string:task_ids>', methods=["GET"])
def query_tasks_status(repository, task_ids=None):

    logger.debug('task_ids %r' % task_ids)
    if not task_ids:
        task_ids_list = session.get('tasks', {}).get(repository, [])
    else:
        task_ids_list = task_ids.split(',')


    logger.debug('tasks_ids_list %r' % task_ids_list)

    res = utils.get_tasks_status(task_ids_list, not task_ids, repository)

    return jsonify(**res)

@meta.route('/help', methods = ['GET'])
def help():
    """Print available functions."""
    func_list = {}
    for rule in app.url_map.iter_rules():
        if rule.endpoint != 'static':
            func_list[rule.rule] = app.view_functions[rule.endpoint].__doc__
    return jsonify(func_list)

@app.context_processor
def inject_running_tasks():
    logger.debug("inject_running_tasks : %r" % request.view_args)
    if 'repository' in request.view_args:
        repository = request.view_args['repository']
        task_ids_list = session.get('tasks', {}).get(repository, [])
        if task_ids_list:
            tasks_status = utils.get_tasks_status(task_ids_list, True, repository)
            return {'running_tasks_nb': tasks_status.get('running_tasks_nb',0)}
        else:
            return {'running_tasks_nb': 0}
    else:
        return {}
