# Catedit

This document will present the structure of the project and dev environment, the different steps to setup a CatEdit server, and what is needed to run it.

### The dev environment

** Vagrant + Puppet : **
After cloning the project repository, you will find a [readme](dev/Puppet_Readme.md) file for Vagrant and Puppet in the /dev folder. Most of the setup of CatEdit dev environment happens in the /dev folder with the exception of the python plugin list located in /virtualenv/requirements.txt

** Project structure : **

Here is the structure of the project directory:

* /dev/ has all the puppet/vagrant files and scripts to set up dev environment
* /src/catedit/ contains the source files
* /src/catedit/static/ contains the static files (js, css ...)
* /src/catedit/template/ contains the html templates
* /virtualenv/ contains the list of python packages

### How to setup a server

** Github config : **  You need a working github repository to use the application. The best way to do this is to have an app admin Github account that will handle all the repository administration. Aside from a working repository, you also need to register the app on github. To do this, you just have to go to your Github settings/applications and register a new application. You will need the "client ID" and "client secret" Github will generate for setting up the config.py file later.

As this app works using the Github API, all the users must have a Github account to edit categories. The users must also be added as collaborators to the categories repository by the repository owner you defined.

** Setting up config.py : **
In the /src/catedit/ folder, you will find a config.py.tmpl. This file is the template of a mandatory config.py file that is used to set up the config of the application. Here are the values you can change in it:

* HOST : The host on which the app will run, default is "0.0.0.0" for development purpose as "localhost" won't work with vagrant and windows.
* LOGGING : Wether or not the app write log files
* LOGGING_LEVEL : if LOGGING is True, indicates what logging level will be used
* DEBUG : Wether or not the app is on debug mode. If True, then each modification of a given file will restart the server allowing for easy development.
* SECRET_KEY : Secret key to secure WTForms
* PERSISTENCE_METHOD : What Persistence method will be used. Currently, either "PersistenceToFile" or "PersistenceToGithub"
* FILE_SAVE_DIRECTORY : If using PersistenceToFile, directory where the turtle files will be saved locally
* REPOSITORY_NAME : The name of the repository your app will use to store categories
* REPOSITORY_OWNER : The name of the owner of the repository (typically a "admin" user)
* CATEGORIES_PATH : Where on the repository categories will be stored. Default to /categories
* GITHUB_CLIENT_ID : The client ID Github gave you when you registered the app
* GITHUB_CLIENT_SECRET : The client secret Github gave you when you registered the app

Once you have set up all the constants you need, save the file as config.py in the /src/catedit folder.

** Starting up the server **
: Once you have a config.py file ready, you can start the server by running the following command from the /src/catedit folder:

    python main.py

## Additional/Advanced informations ##

** Changing the property list : ** If you want to change the property list available to users editing/creating categories, you have to edit the following entry in config.py

* PROPERTY_LIST : My list of properties ...

The list of property has a fixed structure. The property list is a dict of python dicts, each following the fixed structure:

    "propertyKey" : {
        "descriptive_label_fr" : "mylabelfr",
        "descriptive_label_en" : "mylabelen",
        "object_type": "my-object-type",
        "rdflib_class": some-RDFLib-concept,
        "object_rdflib_class": some-RDFLib-class,
    }

* "object_type" : "my-object-type",  -> either "literal", "uriref-category" or "uriref-link" at the moment
* "rdflib_class" : some-RDFLib-concept, -> a rdflib class of some sort with its namespace, examples: SKOS.related or RDF.Type representing the predicate
* "object_rdflib_class" : some-RDFLib-class:  -> a rdflib class representing the object, either Literal or URIRef
