from catedit import app, celery

@celery.task
def submit_changes(self, modified_categories, deleted_categories, message):
    with app.app_context():
        cat_manager_instance = CategoryManager(
            getattr(
                catedit.persistence,
                app.config["PERSISTENCE_CONFIG"]["METHOD"]
            )(repository=repository),
        )
         
        if cat_manager_instance.persistence.session_compliant is True:
            logger.debug(
                "Submitting - deleted categories are:"
                + str(
                    modified_categories
                ) + " and modified categories are:"
                + str(
                    deleted_categories
                )
            )
            cat_manager_instance.save_changes(
                deleted_cat_dict=deleted_categories,
                modified_cat_dict=modified_categories,
                message=message
            )