"""
settings.py:
Contains all settings that are needed but are not to be changed
"""
from rdflib import Namespace


class AppSettings(object):

    # WTForms settings

    WTF_CSRF_ENABLED = True

    # RDF Namespace and prefixes - Must end with #

    BASE_NAMESPACE = "http://ld.iri-research.org/ontology/categorisation"
    CATEGORY_NAMESPACE = Namespace("http://ld.iri-research.org/ontology/categorisation/category#")
    CELERY_IGNORE_RESULT = False
    CELERY_TASK_SERIALIZER = 'json'
    CELERY_ACCEPT_CONTENT = ['json', 'msgpack', 'yaml']
    CELERY_DISABLE_RATE_LIMITS = True
