# Catedit

This document will present the structure of the project and dev environment, the different steps to setup a CatEdit server, and what is needed to run it.

### The dev environment

** Vagrant + Puppet : **
After cloning the project repository, you will find a [readme](dev/Puppet_Readme.md) file for Vagrant and Puppet in the /dev folder. Most of the setup of CatEdit dev environment happens in the /dev folder with the exception of the python plugin list located in /virtualenv/requirements.txt

** Project structure : **

Here is the structure of the project directory:

* /dev/ has all the puppet/vagrant files and scripts to set up dev environment
* /src/catedit/ contains the source files
* /src/catedit/static/ contains the static files (js, css ...)
* /src/catedit/template/ contains the html templates
* /virtualenv/ contains the list of python packages

### How to setup a server

** Github config : **  You need a working github repository to use the application. The best way to do this is to have an app admin Github account that will handle all the repository administration. Aside from a working repository, you also need to register the app on github. To do this, you just have to go to your Github settings/applications and register a new application. You will need the "client ID" and "client secret" Github will generate for setting up the config.py file later.

As this app works using the Github API, all the users must have a Github account to edit categories. The users must also be added as collaborators to the categories repository by the repository owner you defined.

** Setting up config.py : **
In the /src/catedit/ folder, you will find a config.py.tmpl. This file is the template of a mandatory config.py file that is used to set up the config of the application. Here are the values you can change in it:

* HOST : The host on which the app will run, default is "0.0.0.0" for development purpose as "localhost" won't work with vagrant and windows.
* LOGGING : Wether or not the app write log files
* LOGGING_LEVEL : if LOGGING is True, indicates what logging level will be used
* DEBUG : Wether or not the app is on debug mode. If True, then each modification of a given file will restart the server allowing for easy development.
* SECRET_KEY : Secret key to secure WTForms
* PERSISTENCE_METHOD : What Persistence method will be used. Currently, either "PersistenceToFile" or "PersistenceToGithub"
* FILE_SAVE_DIRECTORY : If using PersistenceToFile, directory where the turtle files will be saved locally
* REPOSITORY_NAME : The name of the repository your app will use to store categories
* REPOSITORY_OWNER : The name of the owner of the repository (typically a "admin" user)
* CATEGORIES_PATH : Where on the repository categories will be stored. Default to /categories
* GITHUB_CLIENT_ID : The client ID Github gave you when you registered the app
* GITHUB_CLIENT_SECRET : The client secret Github gave you when you registered the app

Once you have set up all the constants you need, save the file as config.py in the /src/catedit folder.

** Starting up the server **
: Once you have a config.py file ready, you can start the server by running the following command from the /src/catedit folder:

    python main.py

## Additional/Advanced informations ##

** Changing the property list : ** If you want to change the default property list available to users editing/creating categories, you have to edit the following entry in config.py

* PROPERTY_LIST : My list of properties ...

The list of property has a fixed structure. The property list is a dict of python dicts, each following the fixed structure:

    "propertyURI" : {
        "descriptive_label_fr" : "mylabelfr",
        "descriptive_label_en" : "mylabelen",
        "object_type": "my-object-type",
        "rdflib_class": some-RDFLib-concept,
        "usable_in_editor: boolean so the property appears or not in the editor
    }

* "propertyURI" is the complete URI of the property, for a rdflib property that will be the string you get when calling NAMESPACE.property.toPython()
* "object_type" : "my-object-type",  -> either "literal", "uriref-category" or "uriref-link" at the moment
* "usable_in_editor": if true, the property will appear in the editor and users will be able to apply it to categories, if false they won't be able to.
* "rdflib_class" : some-RDFLib-concept, -> a rdflib namespaced property with its namespace, examples: SKOS.related or RDF.Type representing the predicate

** Custom property list **

To setup a custom set of property you need to add a properties/properties.json file in the repository that has 2 values:
* namespace_title is the string that defines the namespace of your custom properties for this repository (not really used right now but will be useful in the future)
* property_list is a dict that follows the exact same format as the config.py property list, of course in json format, so the propertyURI that is used as a key must be written explicitely

If you make the property list evolve, don't forget to keep the old properties you don't want your users to use anymore to ensure backward compatibility. You just need to set the "usable_in_editor" key to false in the property you don't want your users to have access to. Note this won't affect existing categories with this property, but only ensure that they will be readable. Then it's up to the users to "clean up" if a deprecated property is still used.

## Testing Protocol for CatEdit (development) ##

These tests are meant to be run alongside unit tests (that are not completely implemented yet) to test that everything (and specifically Javascript) works properly.

Make sure to work on catedit-dev-testing-2, this repository is only used for development tests to reduce GitHub notification spam for other users. (For the record, catedit-dev-testing is used for other users to test CatEdit functionalities as a whole)

Create and submit 3 categories: toEdit, toDelete, and doNotTouch. doNotTouch must have a "related to" property with "toDelete". Add at least one "link"-type property (resource for instance) and one "text"-type property to test if every type of property. Double-check with the property list in your config.py to check that every property appears on the editor and is correctly configured.

Then, edit the toEdit category and delete the toDelete category. Submit changes and check that comment thread for your submission is created and detected by CatEdit. Add a test comment. Check that doNotTouch isn't related to toDelete anymore (as toDelete was deleted). Also check that the changeset comment thread page also shows you to the repository state before your changes, after your changes, and to all the changes you made.

Create a discussion called "discussion test CatEdit dd/mm/yy" and add a test comment.

Also test that the button "delete all changes" work properly.

Test the javascript on Firefox, Chrome and Safari:
* In the editor, the right fields are generated according to the property type, the property are added to the list when you click the "add property" button, and it is possible to delete each property separately
* In every page that has a category list, the + and - button displays category details properly, and you can hide or show the whole table using the ^ button. The trahsbin and x buttons display a delete confirmation message with the button to delete category or change
* In a changeset page you can hide and show the previous and current state of the category set, and you can hide and show the changes that were made.
