class sysconfig::virtualenv (
    $path_to_virtualenv = hiera('sysconfig::params::path_to_virtualenv', $sysconfig::params::path_to_virtualenv )
) inherits sysconfig::params {

    exec {
            'easy_install_pip':
             command     => 'sudo easy_install pip',
             timeout     => 2400,
             returns     => [ 0, 100 ],
             provider => 'shell';
            'pip_install_virtualenv':
             command     => 'sudo pip install virtualenv',
             timeout     => 2400,
             returns     => [ 0, 100 ],
             provider => 'shell',
             require     => Exec['easy_install_pip'];
             'create_virtualenv':
             command     => "virtualenv -p `which python3.4` ${path_to_virtualenv}",
             timeout     => 2400,
             returns     => [ 0, 100 ],
             provider => 'shell',
             require     => Exec['pip_install_virtualenv'];
            'pip_install_requirements':
             command     => ". ${path_to_virtualenv}/bin/activate && pip install -r /srv/catedit/virtualenv/requirements.txt",
             timeout     => 2400,
             returns     => [ 0, 100 ],
             provider => 'shell',
             require     => Exec['create_virtualenv'];
            # 'create_python_env_script':
            # command     => '/usr/bin/python /srv/catedit/virtualenv/web/create_python_env.py',
            # timeout     => 2400,
            # returns     => [ 0, 100 ],
            # provider => 'shell';
            # 'project_boot_script':
            # command     => "python /srv/catedit/virtualenv/web/project-boot.py ${path_to_virtualenv}",
            # timeout     => 2400,
            # returns     => [ 0, 100 ],
            # provider => 'shell',
            # require     => Exec['create_python_env_script']
            }
    
}