from app import app, github
from models import Category, CategoryManager
from flask import render_template, request, redirect, url_for, session
from flask_wtf import Form
from api import CategoryAPI
from wtforms import StringField, TextAreaField
from wtforms.validators import DataRequired
from rdflib import Graph
from StringIO import StringIO


class NewCategoryMinimalForm(Form):
    label = StringField("Nom de la categorie (obligatoire)", validators=[DataRequired()])
    description = TextAreaField("Description de la categorie (obligatoire)", validators=[DataRequired()])
    commit_message = StringField("Message de soumission (Obligatoire)", validators=[DataRequired()])


@app.route('/', methods=['GET'])
@app.route('/catrecap', methods=['GET'])
@app.route('/catrecap/delete/<string:delete_cat_id>', methods=['GET'])
def cat_recap(delete_cat_id=None):
    cat_api_instance = CategoryAPI()
    # list categories
    if delete_cat_id is None:
        serialized_cat_list = cat_api_instance.get()
        cat_list = []
        for serialized_cat in serialized_cat_list:
            cat_rdf_graph = Graph()
            cat_rdf_graph.parse(source=StringIO(serialized_cat), format='turtle')
            c = Category(graph=cat_rdf_graph)

            cat_list.append({"cat_label": c.label,
                             "cat_description": c.description,
                             "cat_id": c.cat_id,
                             "cat_properties": c.properties})
            # print c.properties
        return render_template('catrecap.html',
                               cat_list=cat_list)
    else:
        cat_api_instance.delete(delete_cat_id)
        return redirect(url_for('cat_recap'))


@app.route('/cateditor', methods=['GET', 'POST'])
@app.route('/cateditor/<string:cat_id>', methods=['GET', 'POST'])
def cat_editor(cat_id=None):
    cat_api_instance = CategoryAPI()
    if cat_id is not None:
        catSerial = cat_api_instance.get(cat_id)

        cat_rdf_graph = Graph()
        cat_rdf_graph.parse(source=StringIO(catSerial), format='turtle')
        c = Category(graph=cat_rdf_graph)

        setattr(NewCategoryMinimalForm,
                'label',
                StringField("Nom de la categorie",
                            validators=[DataRequired()],
                            default=c.label))
        setattr(NewCategoryMinimalForm,
                'description',
                TextAreaField("Description de la categorie",
                              validators=[DataRequired()],
                              default=c.description))
        # print "CatForm fields preset to "+c.label+" and "+c.description

        cat_form = NewCategoryMinimalForm(request.form)

        # GET + cat_id = Edit cat form
        if request.method == 'GET':
            return render_template('cateditor.html',
                                   cat_id=c.cat_id,
                                   cat_properties=c.properties,
                                   form=cat_form)

        # PUT + cat_id = Submit edited cat
        if cat_form.validate_on_submit():
            cat_api_instance.put(cat_id)
            return redirect(url_for('cat_recap'))
        else :
            return render_template('cateditor.html',
                                   cat_id=cat_id,
                                   cat_properties=c.properties,
                                   form=cat_form)

    else:
        setattr(NewCategoryMinimalForm,
                'label',
                StringField("Nom de la categorie",
                            validators=[DataRequired()]))
        setattr(NewCategoryMinimalForm,
                'description',
                TextAreaField("Description de la categorie",
                              validators=[DataRequired()]))

        cat_form = NewCategoryMinimalForm(request.form)

        # GET seul = Create cat form
        if request.method == 'GET':
            return render_template('cateditor.html',
                                   form=cat_form)

        # POST seul = Submit created cat
        if cat_form.validate_on_submit():
            cat_api_instance.post()
            return redirect(url_for('cat_recap'))
        else :
            return render_template('cateditor.html',
                                   form=cat_form)

@app.route('/catedit-github-login')
def github_login():
    return github.authorize(scope="repo")

@app.route('/catedit-github-callback')
@github.authorized_handler
def github_callback(oauth_code):
    session.permanent = False
    session["user_code"] = oauth_code
    session["user_logged"] = True
    session["user_login"] = github.get("user")["login"]
    # print session["user_login"]
    return redirect(url_for('cat_recap'))

@github.access_token_getter
def token_getter():
    if session.get("user_logged",None):
        return session["user_code"]

@app.route('/catedit-logout')
def logout():
    session["user_code"] = None
    session["user_logged"] = None
    session["user_login"] = None
    return redirect(url_for('cat_recap'))
