from catedit import app, celery, cache
from catedit.models import CategoryManager
import catedit.persistence
import logging
from flask import g, url_for
import requests

logger = logging.getLogger(__name__)

@celery.task
def submit_changes(modified_categories, deleted_categories, message, repository, token):
    with app.app_context():
        g.user_code = token
        cat_manager_instance = CategoryManager(
            getattr(
                catedit.persistence,
                app.config["PERSISTENCE_CONFIG"]["METHOD"]
            )(repository=repository),
        )

        if cat_manager_instance.persistence.session_compliant is True:
            logger.debug(
                "Submitting - deleted categories are:"
                + str(
                    modified_categories
                ) + " and modified categories are:"
                + str(
                    deleted_categories
                )
            )
            cat_manager_instance.save_changes(
                deleted_cat_dict=deleted_categories,
                modified_cat_dict=modified_categories,
                message=message
            )
            requests.get(app.config['BASE_URL']+"/cache-clear-after-task")

@app.route('/cache-clear-after-task', methods=["GET"])
def cache_clear_endpoint():
    cache.clear()
    return ('', 204)
