var CatEditScripts=CatEditScripts||(function(){
  var propertyCount=0;
  var createdProperties=0;

  return {
    initCreatedProperties : function(initValue){
      createdProperties=initValue;
    },

    initPropertyCount : function(divName,initValue){
      propertyCount=initValue;
      if (propertyCount > 0) {
        document.getElementById(divName).className="visible";
      }
    },

    addProperty : function(divToReveal, divToAddFieldsTo){
        var selectElement = document.getElementById('property_selector');
        if (selectElement.options[selectElement.selectedIndex].id != "property_type_default") {
          var selectedOptionValue = selectElement.options[selectElement.selectedIndex].value;
          var selectedOptionText = selectElement.options[selectElement.selectedIndex].text;
          var propertyOptionObjectType = selectElement.options[selectElement.selectedIndex].label;
          var propertyObjectValue = "default: something went wrong"
          switch(propertyOptionObjectType) {
            case "literal":
              propertyObjectValue = document.getElementById('literal-field').value;
              propertyObjectText = document.getElementById('literal-field').value;
              break;
            case "uriref-category":
              var selectingCatBox = document.getElementById('uriref-category-field');
              propertyObjectText = selectingCatBox[selectingCatBox.selectedIndex].innerHTML;
              propertyObjectValue = selectingCatBox.value;
              break;
            case "uriref-link":
              propertyObjectValue = document.getElementById('uriref-link-field').value;
              propertyObjectText = document.getElementById('uriref-link-field').value;
              break;
            default:
              optionObject='<span class="glyphicon glyphicon-exclamation-sign"/>'
          }

          if (((propertyObjectValue != "") && (propertyOptionObjectType == "literal")) ||
             ((propertyObjectValue != "") && (propertyOptionObjectType == "uriref-link")) ||
             ((propertyObjectValue != "default") && (propertyOptionObjectType == "uriref-category"))) {
            var newProperty = document.createElement('tr');
            newProperty.setAttribute('id','property_tr'+(createdProperties+1));
            var newPropertyHTML = '<input type="hidden" id="property_predicate'+(createdProperties+1)+'" name="property_predicate" value="'+selectedOptionValue+'"> \
                                   <input type="hidden" id="property_object'+(createdProperties+1)+'" name="property_object" value="'+propertyObjectValue+'"> \
                                   <td id="predicate_td'+(createdProperties+1)+'"> \
                                     <strong>'+selectedOptionText+'</strong> \
                                   </td> \
                                   <td id="object_td'+(createdProperties+1)+'">'
                                     +propertyObjectText+
                                  '</td> \
                                   <td id="delete_button'+(createdProperties+1)+'"> \
                                    <input type="button" id="property_delete_button'+(createdProperties+1)+'" class="btn btn-default property-delete-button" onClick="CatEditScripts.removeProperty('+(createdProperties+1)+',properties)" value="Supprimer"> \
                                   </td>';

            newProperty.innerHTML = newPropertyHTML ;
            parentElement=document.getElementById(divToAddFieldsTo) ;
            parentElement.insertBefore(newProperty, parentElement.firstChild);
            createdProperties++;
            propertyCount++;
            if (propertyCount > 0) {
              document.getElementById(divToReveal).className="visible";
            }
          }
        }
    },

    removeProperty : function(index, divToReveal){
        if (propertyCount > 0) {
          divItem=document.getElementById("property_tr"+index);
          divItem.parentNode.removeChild(divItem);
          propertyCount--;
          if (propertyCount == 0) {
            document.getElementById(divToReveal).className="hidden";
          }
      }
    },

    displayCorrespondingField : function() {
      propertySelectItem = document.getElementById("property_selector");
      switch(propertySelectItem[propertySelectItem.selectedIndex].label)
      {
        case "property_type_default":
          document.getElementById("literal-field").className = "hidden form-control";
          document.getElementById("uriref-category-field").className = "hidden form-control";
          document.getElementById("uriref-category-field-text").className = "hidden";
          document.getElementById("uriref-link-field").className = "hidden form-control";
          break;
        case "literal":
          document.getElementById("literal-field").className = "visible form-control";
          document.getElementById("uriref-category-field").className = "hidden form-control";
          document.getElementById("uriref-category-field-text").className = "hidden";
          document.getElementById("uriref-link-field").className = "hidden form-control";
          break;
        case "uriref-category":
          document.getElementById("literal-field").className = "hidden form-control";
          document.getElementById("uriref-category-field").className = "visible form-control";
          document.getElementById("uriref-category-field-text").className = "visible";
          document.getElementById("uriref-link-field").className = "hidden form-control";
          break;
        case "uriref-link":
          document.getElementById("literal-field").className = "hidden form-control";
          document.getElementById("uriref-category-field").className = "hidden form-control";
          document.getElementById("uriref-category-field-text").className = "hidden";
          document.getElementById("uriref-link-field").className = "visible form-control";
          break;
        default:
          document.getElementById("literal-field").className = "hidden form-control";
          document.getElementById("uriref-category-field").className = "hidden form-control";
          document.getElementById("uriref-category-field-text").className = "hidden";
          document.getElementById("uriref-link-field").className = "hidden form-control";
      }
    }
  };

}());
