var myPodium,
    myTweetSource,
    myQueueManager;

function updateLastTweetList() {
    var _filtered = myTweetSource.afterDate(startHour),
        _txtFilter = $("#btv-cp-champ-filtre").val(),
        _reFilter = null;
    if (_txtFilter.length > 1) {
        _filtered = _filtered.search(_txtFilter);
        _reFilter = regexpFromText(_txtFilter);
    }
    $('#btv-cp-liste-tweets-tout').html(
        _filtered.reverse().slice(0,20).map(function(_t) {
            return '<li onclick="addTweetToSelection(\''
                + _t.id_str
                + '\'); return false;"><a title="Ajouter à la sélection" href="#"><span class="btv-cp-tweet-date">'
                + _t.created_at.match(/\d+:\d+:\d+/)[0]
                + '</span> <span class="btv-cp-tweet-from">'
                + ( _reFilter ? ('@' + _t.from_user).replace(_reFilter, '<span class="btv-cp-highlight">$1</span>') : ('@' + _t.from_user) )
                + '</span> <span class="btv-cp-tweet-text">'
                + ( _reFilter ? _t.text.replace(_reFilter, '<span class="btv-cp-highlight">$1</span>') : _t.text )
                + '</span><div class="btv-cp-tweet-button btv-cp-tweet-add"></div></a></li>'
        }).join('')
    );
}

function addTweetToSelection(tweetId) {
    var _t = myTweetSource.tweetById(tweetId);
    if (_t) {
        $("#btv-cp-liste-tweets-selection").prepend(
            '<li><a title="Afficher sur l\'écran" href="#" onclick="showTweetOnScreen(\''
            + _t.id_str
            + '\'); return false;"><span class="btv-cp-tweet-date">'
            + _t.created_at.match(/\d+:\d+:\d+/)[0]
            + '</span> <span class="btv-cp-tweet-from">@'
            + _t.from_user
            + '</span> <span class="btv-cp-tweet-text">'
            + _t.text
            + '</span><div class="btv-cp-tweet-button btv-cp-tweet-show"></div></a>'
            + '<a title="Supprimer de cette liste" href="#" onclick="$(this).parent().detach(); return false;"><div class="btv-cp-tweet-button btv-cp-tweet-remove"></div></a></li>'
        );
    }
}

function showTweetOnScreen(tweetId) {
    var _t = myTweetSource.tweetById(tweetId);
    console.log(_t);
    if (_t) {
        $("#btv-bigtweet").html('<img class="btv-bigtweet-image" src="'
        + _t.profile_image_url
        + '" /><p class="btv-bigtweet-screen-name">'
        + _t.from_user
        + '</p><p class="btv-bigtweet-name">'
        + _t.from_user_name
        +'</p><p class="btv-bigtweet-text">'
        + _t.text
        +'</p>').show();
        $(".btv-cp-hide-tweets").show();
    }
}

$(function() {
    setInterval(function() {
        var _t = Math.floor((new Date() - startHour)/1000),
            _s = _t % 60,
            _m = Math.floor(_t/60) % 60,
            _h = Math.floor(_t/3600);
        $("#btv-cp-temps").html(
            _h  + ':' + (_m < 10 ? '0' : '') + _m + ':' + (_s < 10 ? '0' : '') + _s
        )
    }, 500);
    myPodium = new Btv_Podium([0,0,0,0], { minHeight: 50 });
    
    
    $("#podium-labels").html(columnKeywords.map(function(_w) {
        return '<li>' + _w + '</li>'
    }).join(""));
    
    myTweetSource = new Btv_TweetSource({
        keywords: searchKeywords
    });
    
    myTweetSource.setOnNewTweets(function() {
        var _filtered = this.afterDate(startHour);
        $("#btv-cp-nb-tweets").html(_filtered.count());
        var _counts = [];
        for (var _i = 0; _i < columnKeywords.length; _i++) {
            _counts.push(_filtered.search(columnKeywords[_i]).count());
        }
        updateLastTweetList();
        myPodium.update(_counts);
        $("#podium-chiffres").html(_counts.map(function(_c) {
            return '<li>' + _c + '</li>'
        }).join(""));
    });
    myQueueManager = new Btv_TweetQueueManager(myTweetSource, function(_t) {
        var _cat = -1;
        for (var i = 0; i < columnKeywords.length; i++) {
            if (_t.text.search(regexpFromText(columnKeywords[i])) != -1) {
                _cat = i;
                break;
            }
        }
        if (_cat != -1) {
            if (_cat == 2) {
                console.log(_t.text);
            }
            _t.cat = _cat;
            createBallTweetForce(_t);
            checkSilos();
        }
});
    
    $("#btv-cp-champ-filtre").keyup(function() {
        updateLastTweetList();
    });
    $("#btv-cp-clear-filtre").click(function() {
        $("#btv-cp-champ-filtre").val("");
        updateLastTweetList();
        return false; 
    });
    $("#btv-bigtweet, .btv-cp-hide-tweets").click(function() {
        $("#btv-bigtweet, .btv-cp-hide-tweets").hide();
    });
    $("#btv-cp-cont-pause-amont").click(function() {
       if (myQueueManager.playPause()) {
           $(this).removeClass("btv-cp-status-pause");
           $(this).addClass("btv-cp-status-play");
       } else {
           $(this).addClass("btv-cp-status-pause");
           $(this).removeClass("btv-cp-status-play");
       }
    });
});