var canvas;
var tooltipOpen=true;
var Width  = 960;
var Height = 400;
var delta = [0, 0];
var stage = [195, 250, 1150, 835]   //     bottom
var b2bod = [];

var BALL_SIZE = 40;
              
var worldAABB, world, iterations = 1, timeStep = 1 / 20;

var walls = [];
var wall_thickness = 10;
var wallsSetted = false;

var bodies, elements, text;

var createMode = false;
var destroyMode = false;

var emptyBottom = true;

var isFreezing = false;
var refLoop, refFileAttente;

var isMouseDown = false;
var isMouseDragging = false;
var isMouseDragging2 = true;
var mouseJoint;
var mouse = { x: 0, y: 0 };
var gravity = { x: 0, y: 0.3 };

var PI2 = Math.PI * 2;

var timeOfLastTouch = 0;
var tweetSilos = [];

init();
play();
/*
listLastTweets();
getInitialTweets();
TweetAnim.shiftQueue();
*/
function init() {
/*
	var canvas = document.getElementById('tube-container');
  canvas.onmousedown = onDocumentMouseDown;
	canvas.onmouseup = onDocumentMouseUp;
	canvas.onmousemove = onDocumentMouseMove;
  
	var canvas = document.getElementById('canvas');
  canvas.onmousedown = onDocumentMouseDown;
	canvas.onmouseup = onDocumentMouseUp;
	canvas.onmousemove = onDocumentMouseMove;  

  var canvas = document.getElementById('btn-tweet-next');
  canvas.onmousedown = onDocumentMouseDown;
	canvas.onmouseup = onDocumentMouseUp;
	canvas.onmousemove = onDocumentMouseMove;  
  */
	worldAABB = new b2AABB();
	worldAABB.minVertex.Set( -200, -200 );
	worldAABB.maxVertex.Set( window.innerWidth + 200, window.innerHeight + 200 );

	world = new b2World( worldAABB, new b2Vec2( 0, 0 ), true );

	setWalls();
	reset();
}


function play() {

  if(!isFreezing)
    refLoop = setInterval( loop, 1000 / 40 );
 else
    clearInterval(refLoop);
    
  isFreezing = !isFreezing;
}

function reset() {

	if(bodies) {
		for (var i= 0; i < bodies.length; i++ ) {
			var body = bodies[ i ]
			canvas.removeChild( body.GetUserData().element );
			world.DestroyBody( body );
			body = null;
		}
	}
	bodies = [];
	elements = [];
}

function onDocumentMouseDown() {
  isMouseDragging = false;
	isMouseDown = true;
	return false;
}

function onDocumentMouseUp() {
	isMouseDown = false;
	return false;
}

function onDocumentMouseMove( event ) {

  if(isMouseDown)
    isMouseDragging = true;
	mouse.x = event.clientX;
	mouse.y = event.clientY;
	
}

function onDocumentTouchStart( event ) {

		

	if( event.touches.length == 1 ) {

		event.preventDefault();

		// Faking double click for touch devices

		var now = new Date().getTime();

		if ( now - timeOfLastTouch  < 250 ) {

			reset();
			return;
		}

		timeOfLastTouch = now;

		mouse.x = event.touches[ 0 ].pageX;
		mouse.y = event.touches[ 0 ].pageY;
		isMouseDown = true;
	}
}

function onDocumentTouchMove( event ) {

	if (event.touches.length == 1) {

		event.preventDefault();
		mouse.x = event.touches[ 0 ].pageX;
		mouse.y = event.touches[ 0 ].pageY;
	}
}

function onDocumentTouchEnd( event ) {

	if (event.touches.length == 0) {
		event.preventDefault();
		isMouseDown = false;
	}
}

function loop() {

	delta[0] += (0 - delta[0]) * .5;
	delta[1] += (0 - delta[1]) * .5;
	world.m_gravity.x = gravity.x * 350 + delta[0];
	world.m_gravity.y = gravity.y * 350 + delta[1];

	mouseDrag();
	world.Step(timeStep, iterations);

	for (i = 0; i < bodies.length; i++) {
		var body = bodies[i];
		var element = elements[i];
		element.style.left = (body.m_position0.x - (element.width >> 1)) + 'px';
		element.style.top = (body.m_position0.y - (element.height >> 1)) + 'px';

		if (element.tagName == 'DIV') {
			var rotationStyle = 'rotate(' + (body.m_rotation0 * 57.2957795) + 'deg)';
			text.style.WebkitTransform = rotationStyle;
			text.style.MozTransform = rotationStyle;
			text.style.OTransform = rotationStyle;
			text.style.msTransform = rotationStyle;
		}
	}
}

function createBox(world, x, y, width, height, fixed) {

var c=document.createElement('canvas');
var ctx=c.getContext("2d");
ctx.fillStyle="#FF0000";
ctx.fillRect(0,0,1500,750);

	if (typeof(fixed) == 'undefined') {
		fixed = true;
	}

	var boxSd = new b2BoxDef();

	if (!fixed) {
		boxSd.density = 1.0;
	}

	boxSd.extents.Set(width, height);
	var boxBd = new b2BodyDef();
	boxBd.AddShape(boxSd);
	boxBd.position.Set(x,y);

  
	return world.CreateBody(boxBd);
}

function mouseDrag()
{
	// mouse press
	if (createMode) {

	} else if (isMouseDown && !mouseJoint) {

		var body = getBodyAtMouse();

		if (body) {
			var md = new b2MouseJointDef();
			md.body1 = world.m_groundBody;
			md.body2 = body;
			md.target.Set(mouse.x, mouse.y);
			md.maxForce = 30000 * body.m_mass;
			md.timeStep = timeStep;
			mouseJoint = world.CreateJoint(md);
			body.WakeUp();
		} else {
			createMode = true;
		}
	}

	if (!isMouseDown) { // mouse release

		createMode = false;
		destroyMode = false;

		if (mouseJoint) {
			world.DestroyJoint(mouseJoint);
			mouseJoint = null;
		}
	}
	
	if (mouseJoint) { // mouse move
		var p2 = new b2Vec2(mouse.x, mouse.y);
		mouseJoint.SetTarget(p2);
	}
}

function getBodyAtMouse() {

	// Make a small box.
	var mousePVec = new b2Vec2();
	mousePVec.Set(mouse.x, mouse.y);

	var aabb = new b2AABB();
	aabb.minVertex.Set(mouse.x - 1, mouse.y - 1);
	aabb.maxVertex.Set(mouse.x + 1, mouse.y + 1);

	// Query the world for overlapping shapes.
	var k_maxCount = 10;
	var shapes = new Array();
	var count = world.Query(aabb, shapes, k_maxCount);
	var body = null;

	for (var i = 0; i < count; ++i) {
		if (shapes[i].m_body.IsStatic() == false) {
			if ( shapes[i].TestPoint(mousePVec) ) {
				body = shapes[i].m_body;
				break;
			}
		}
	}
	return body;
}

function setWalls() {

	if (wallsSetted) {
		world.DestroyBody(walls[0]);
		world.DestroyBody(walls[1]);
		world.DestroyBody(walls[2]);
		world.DestroyBody(walls[3]);
		walls[0] = null; 
		walls[1] = null;
		walls[2] = null;
		walls[3] = null;
	} else {
  
  wall_thickness = 20;
  
  walls[0] = createBox(world, 1910, 900, wall_thickness, 900); //  rightmost wall
  walls[1] = createBox(world, 1540, 600, wall_thickness, 300); //  wall 4 / 3
  
  walls[2] = createBox(world, 1160, 600, wall_thickness, 300); //  wall 3 / 2
  walls[3] = createBox(world, 790, 600, wall_thickness, 300); //   wall 2 / 1
  walls[4] = createBox(world, 420, 600, wall_thickness, 300); //   leftmostwall    
 
  walls[5] = createBox(world, 580, 600, 170, 10); //  4    
  walls[6] = createBox(world, 950, 750, 170, 10); //  3   
  walls[7] = createBox(world, 1320, 750, 170, 10); //  2   
  walls[8] = createBox(world, 1690, 600, 170, 10); //  1   
  
  setInterval(function() {
  
    if($('#podium div').size() > 0) {
      
      $('#podium div').each( function(idx, panel) {
     
      var idxWall = 5+idx;
      var yWall = 945-$(this).height();
      world.DestroyBody(walls[idxWall]);
      walls[idxWall] = createBox(world, 580+370*idx, yWall, 170, 10);      
      
      });
    }
  }, 1000);
  
//  walls[6] = createBox(world, 1340, 800, 170, 10); //  3 
  
  /*
  setInterval(function() {
    
    var tmp = walls[5].m_position.y;
    world.DestroyBody(walls[5]);
    walls[5] = createBox(world, 1690, tmp-1, 170, 10, true);
  
    console.log(walls[5].m_position.y);

  }, 1000);
  */

  /*
    walls[0] = createBox(world, stage[0] , stage[3] + wall_thickness-32, stage[2], wall_thickness); // bottom wall
    
    walls[2] = createBox(world, stage[2]-400, 850, 50, 100); // middle wall
    
   // walls[3] = createBox(world, stage[2]-400, 100, wall_thickness, 700); // right wall
    walls[3] = createBox(world, 300, 800, 100, 200); // left wall
/*
    for (var i = 0; i < candidats.length; i++) { // drawing silos walls
      createBox(world, (stage[2]/candidats.length*i)-(wall_thickness/3), stage[3], wall_thickness/3, 200);
    }
    */
  }
}

function  createBallTweetForce(t) {


	var xpos = 40;
  var ypos = 70;
   
	var element = document.createElement( 'div' );
	element.width = BALL_SIZE;
	element.height = BALL_SIZE;	
	element.style.position = 'absolute';
	element.style.left = -200 + 'px';
	element.style.top = -200 + 'px';
	element.style.cursor = "default";
  element.style.hover = "red";
	element.id = t.id_str;
  
  var id = "tweet_"+bodies.length;
var canvas = document.getElementById( 'canvas' );
	canvas.appendChild(element);
	elements.push( element );

	$("#"+t.id_str).mouseover(function() {
		
		$(this).fadeTo(250, 0.1);
		$("#tooltip-bulle .tweet-screen-name").text(t.from_user);
		$("#tooltip-bulle .tweet-full-name").text(t.from_user_name);
		$("#tooltip-bulle .tweet-text").text(t.text);
		$("#tooltip-bulle .tweet-time").text(t.created_at);
		$("#tooltip-bulle .tweet-img-avatar").attr( 'src' , t.profile_image_url );
		var thisX = parseInt($(this).css('left'),10)+10;
//		console.log(thisX);//visibility:hidden
		 $('#bulle-tooltip-template').css('visibility','visible');
		 //$('#bulle-tooltip-template').css('top', thisX).css('left', thisY);
		$(this).css('cursor','pointer');
		if(thisX<960/2){
			$('#accolade-left').css('visibility','visible');
		}else{
			$('#accolade-right').css('visibility','visible');
		}
	    
	});
  
	$("#"+t.id_str).mouseout(function() {
		 $('#bulle-tooltip-template').css('visibility','hidden');
			$('#accolade-right').css('visibility','hidden');
			$('#accolade-left').css('visibility','hidden');
		$(this).css('cursor','auto');
		
		$(this).dequeue();
		$(this).fadeTo(250, 0.8);
	});
   
  $("#"+t.id_str).click(function() {
		if(!isMouseDragging) {
            fancyBoxTwitter(t.from_user, (t.candidats && t.candidats.length ? candidats[t.candidats[0]].couleur : '#666699'));
//      window.open("https://twitter.com/#!/"+t.from_user+"/status/"+t.id_str);
    }
  });

  BALL_SIZE = 150;
  
  var circle = document.createElement('canvas');
  circle.width = BALL_SIZE;
  circle.height = BALL_SIZE;

  var offset = (48 - BALL_SIZE)/2;
  
  var graphics = circle.getContext('2d');
  		graphics.fillStyle = "white";
		graphics.beginPath();
		graphics.arc(BALL_SIZE* .25+10, BALL_SIZE* .25, BALL_SIZE* .25, 0, PI2, true); 
		graphics.closePath();
		graphics.fill();
    
  graphics.fillStyle = "#E2F0D6";
  graphics.beginPath();
  graphics.arc(BALL_SIZE * .5 +offset+24, BALL_SIZE * .5+offset+14, BALL_SIZE * .20, 0, PI2, true);
  graphics.closePath();
  graphics.fill();

  var size = BALL_SIZE;
//	for (var i = size; i > 0; i-= (size/10)) {



    //	}
  
  /* ORIGIN
    graphics.fillStyle = "#E2F0D6";
  graphics.beginPath();
  graphics.arc(BALL_SIZE * .5 +offset, BALL_SIZE * .5+offset, BALL_SIZE * .25, 0, PI2, true);
  graphics.closePath();
  graphics.fill();

  */
  
  var img = new Image();
  img.src = t.profile_image_url;

  img.onload = function(){
  
    var canvasCopy = document.createElement("canvas");
    var copyContext = canvasCopy.getContext("2d");
    
    canvasCopy.width = 96;
    canvasCopy.height = 96;
    copyContext.drawImage(img, 0, 0, 96, 96);

    var ptrn = graphics.createPattern(canvasCopy,'no-repeat');
    graphics.fillStyle = ptrn;
    graphics.fill(-5,0,150,150);

  }
  
  
  
	element.appendChild( circle );

	text = document.createElement( 'div' );
	text.onSelectStart = null;
	text.style.color = "#95AB63";
	text.style.position = 'absolute';
	text.style.left = '0px';
	text.style.top = '0px';
	text.style.fontFamily = 'Georgia';
	text.style.textAlign = 'center';
	element.appendChild(text);
  
	var circle = new b2CircleDef();
	circle.radius = BALL_SIZE/4+2 ;
	circle.density = 1;
	circle.friction = 0.3;
	circle.restitution = 0.3;
  
	var b2body = new b2BodyDef();  
	b2body.AddShape(circle);
	b2body.userData = {element: element};
	b2body.position.Set( xpos, ypos);
  
  var a, b;

  switch (t.cat) { 
    case 0: // 1
      a = 150;
      b = -100;
      break; 
    case 1: // 2
      a = 250;
      b = -150;
      break; 
    case 2: // 3
      a = 350;
      b = -100;
      break; 
    case 3: // 4
      a = 390;
      b = -180;
      break;     
       /*
    case 4: // Jean-Pierre Chevènement
      a = 390;
      b = -180;
      break;    
     
    case 5: // Eva Joly
      a = 170;
      b = -30;
      break;   
    case 6:  // Corinne Lepage
      a = 200;
      b = -40;
      break;    
    case 7: //  François Bayrou
      a = 200;
      b = -60;
      break;  
    case 8: // Hervé Morin
      a = 230;
      b = -60;
      break;        
    case 9: //  Dominique de Villepin 
      a = 260;
      b = -60;
      break;       
     case 10: // Nicolas Sarkozy 
      a = 290;
      b = -60;
      break;     
     case 11: //  Nicolas Dupont-Aignan
      a = 300;
      b = -70;
      break;         
     case 12: // Frederic Nihous 
      a = 320;
      b = -70;
      break;   
     case 13: // Christine Boutin
      a = 350;
      b = -70;
      break;   
     case 14: // Marine Le pen
      a = 390;
      b = -80;
      break;   
    
    default:
      a = 390;
      b = -180;
      console.log("default impulse!");
      break; 
        */
  }

  b2body.linearVelocity.Set(a, b);
  b2bod[t.id_str] = world.CreateBody(b2body);
	bodies.push(b2bod[t.id_str]);	
}