"""
Call this like ``python fassembler/create_python_env.py``; it will
refresh the blinkster-boot.py script

-prerequisite:

- virtualenv
- distribute
- psycopg2 requires the PostgreSQL libpq libraries and the pg_config utility


"""
import os
import subprocess
import re

here = os.path.dirname(os.path.abspath(__file__))
base_dir = os.path.dirname(here)
script_name = os.path.join(base_dir, 'blinkster-boot.py')

import virtualenv

# things to install
# - psycopg2
# - PIL
# - pylucene
# - pyxml
# - 4Suite-xml


EXTRA_TEXT = """

import shutil
import tarfile
import urllib

def extend_parser(parser):
    parser.add_option(
        '--svn',
        metavar='DIR_OR_URL',
        dest='fassembler_svn',
        default=FASS_SVN_LOCATION,
        help='Location of a svn directory or URL to use for the installation of fassembler')

def adjust_options(options, args):
    if not args:
        return # caller will raise error
    
    # We're actually going to build the venv in a subdirectory
    base_dir = args[0]
    if len(args) > 1:
        venv_name = args[1]
    else:
        venv_name = "blinkster"
        
    args[0] = join(base_dir, venv_name)

def after_install(options, home_dir):
    base_dir = os.path.dirname(home_dir)
    src_dir = join(home_dir, 'src')
    tmp_dir = join(home_dir, 'tmp')
    ensure_dir(src_dir)
    ensure_dir(tmp_dir)
    #logger.indent += 2
    try:
        call_subprocess([os.path.abspath(join(home_dir, 'bin', 'easy_install')), 'psycopg2'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        call_subprocess([os.path.abspath(join(home_dir, 'bin', 'easy_install')), 'pyxml'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        call_subprocess([os.path.abspath(join(home_dir, 'bin', 'easy_install')), '4suite-xml'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        call_subprocess([os.path.abspath(join(home_dir, 'bin', 'easy_install')), 'pil'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        call_subprocess([os.path.abspath(join(home_dir, 'bin', 'easy_install')), 'pil'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)

#get pylucene
#cd jcc
#install jcc
#cd pylucene
#instqll pylucene
#delete src
        #call_subprocess([os.path.abspath(join(home_dir, 'bin', 'python')), 'setup.py', 'develop'],
        #                cwd=os.path.abspath(fassembler_dir),
        #                filter_stdout=filter_python_develop,
        #                show_stdout=False)
    finally:
        logger.indent -= 2
    script_dir = join(base_dir, 'bin')
    logger.notify('Run "%s Package" to install new packages that provide builds'
                  % join(script_dir, 'easy_install'))

def ensure_dir(dir):
    if not os.path.exists(dir):
        logger.info('Creating directory %s' % dir)
        os.makedirs(dir)

def filter_python_develop(line):
    if not line.strip():
        return Logger.DEBUG
    for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                   'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                   'creating ', 'Copying ']:
        if line.startswith(prefix):
            return Logger.DEBUG
    return Logger.NOTIFY
"""

def main():
    text = virtualenv.create_bootstrap_script(EXTRA_TEXT, python_version='2.4')
    if os.path.exists(script_name):
        f = open(script_name)
        cur_text = f.read()
        f.close()
    else:
        cur_text = ''
    print 'Updating %s' % script_name
    if cur_text == 'text':
        print 'No update'
    else:
        print 'Script changed; updating...'
        f = open(script_name, 'w')
        f.write(text)
        f.close()

if __name__ == '__main__':
    main()

