# Create your views here.
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render_to_response, get_object_or_404
from django.core.urlresolvers import reverse
from django.template import RequestContext, TemplateDoesNotExist
from django.template.loader import get_template
from django.core import serializers
from django.core.serializers.json import DjangoJSONEncoder
from django.utils import simplejson

from blinkster.models import Roi, Poi
import blinkster

def serialize_queryset_to_json(response, obj_list):
    objs = {
        "version" : blinkster.VERSION,
        "list" : obj_list,
    }
    simplejson.dump(objs, response, cls=DjangoJSONEncoder,ensure_ascii=False, indent=4)
    return response

def roi_list(request):

    content_type = request.GET.get("content-type", "application/json; charset=utf-8")

    response = HttpResponse(content_type=str(content_type))
    return serialize_queryset_to_json(response, [roi.serialize_to_dict() for roi in Roi.objects.all()])

def poi_list(request, roi_sid):
    content_type = request.GET.get("content-type", "application/json; charset=utf-8")
    response = HttpResponse(content_type=str(content_type))
    roi = get_object_or_404(Roi, sid=roi_sid)
    return serialize_queryset_to_json(response, [poi.serialize_to_dict() for poi in Poi.objects.filter(roi=roi)]) 
