from django.conf.urls.defaults import *

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
admin.autodiscover()

import blinkster.settings

urlpatterns = patterns('',
    # Example:
    # (r'^blinkster/', include('blinkster.foo.urls')),

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    (r'^admin/import/form$', 'blinkster.ldt.views.importFile'),
    (r'^admin/import/upload/$', 'blinkster.ldt.views.uploadFile'),
    (r'^admin/export/form$', 'blinkster.ldt.views.exportForm'),
    (r'^admin/export/ldt/$', 'blinkster.ldt.views.downloadLdt'),
    (r'^admin/reindex/$', 'blinkster.ldt.views.reindex'),
    (r'^admin/import/projectForm$', 'blinkster.ldt.views.importProjectFile'),
    (r'^admin/import/uploadProject/$', 'blinkster.ldt.views.uploadProjectFile'),
    # Uncomment the next line to enable the admin:
    (r'^admin/(.*)', admin.site.root),
    
    
    (r'^ldt/index/(?P<url>.*)$', 'blinkster.ldt.views.index'),
    (r'^ldt/indexproject/(?P<id>.*)$', 'blinkster.ldt.views.indexProject'),
    (r'^ldt/init/(?P<method>.*)/(?P<url>.*)$', 'blinkster.ldt.views.init'),
    (r'^ldt/searchInit/(?P<field>.*)/(?P<query>.*)$', 'blinkster.ldt.views.searchInit'),
    (r'^ldt/searchForm$', 'blinkster.ldt.views.searchForm'),
    (r'^ldt/search/$', 'blinkster.ldt.views.searchIndex'),
    (r'^ldt/search/(?P<field>.*)/(?P<query>.*)$', 'blinkster.ldt.views.searchIndexGet'),
    (r'^ldt/searchLdt/(?P<field>.*)/(?P<query>.*)$', 'blinkster.ldt.views.searchLdt'),
    (r'^ldt/searchSeg/(?P<field>.*)/(?P<query>.*)$', 'blinkster.ldt.views.searchSegments'),
    (r'^ldt/gen/(?P<url>.*)$', 'blinkster.ldt.views.ldt'),
    (r'^ldt/project/(?P<id>.*)$', 'blinkster.ldt.views.ldtProject'),
    (r'^ldt/projectslist/(?P<content_id>.*)$', 'blinkster.ldt.views.getProjectFromContentId'),
    #(r'^.*(?P<content>flvplayer|mp3player|ClearExternalAllBlue)\.swf$','django.views.generic.simple.redirect_to', {'url':blinkster.settings.BASE_URL+'/static/swf/ldt/pkg/%(content)s.swf'}),
    (r'^roi/list/$', 'blinkster.views.roi_list'),
    (r'^poi/list/(?P<roi_sid>.*)/$', 'blinkster.views.poi_list'),
    (r'^segment/detail/(?P<iri_id>.*)/(?P<ensemble_id>.*)/(?P<cutting_id>.*)/(?P<element_id>.*)/$', 'blinkster.views.segment_detail'),
    (r'^segment/search/$','blinkster.views.segment_search_post'),
    (r'^segment/search/(?P<field>tags|title|abstract|all)/(?P<operator>or|and)/(?P<query>.*)/$','blinkster.views.segment_search_get'),
    (r'^photologue/', include('photologue.urls')),
    
)
