/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.analysis.cn.smart;

/**
 * Internal SmartChineseAnalyzer token type constants
 * <p><font color="#FF0000">
 * WARNING: The status of the analyzers/smartcn <b>analysis.cn.smart</b> package is experimental. 
 * The APIs and file formats introduced here might change in the future and will not be 
 * supported anymore in such a case.</font>
 * </p>
 */
public class WordType {

  /**
   * Start of a Sentence
   */
  public final static int SENTENCE_BEGIN = 0;

  /**
   * End of a Sentence
   */
  public final static int SENTENCE_END = 1;

  /**
   * Chinese Word 
   */
  public final static int CHINESE_WORD = 2;

  /**
   * ASCII String
   */
  public final static int STRING = 3;

  /**
   * ASCII Alphanumeric 
   */
  public final static int NUMBER = 4;

  /**
   * Punctuation Symbol
   */
  public final static int DELIMITER = 5;

  /**
   * Full-Width String
   */
  public final static int FULLWIDTH_STRING = 6;

  /**
   * Full-Width Alphanumeric
   */
  public final static int FULLWIDTH_NUMBER = 7;

}
