"""
Call this like ``python fassembler/create_python_env.py``; it will
refresh the blinkster-boot.py script

-prerequisite:

- virtualenv
- distribute
- psycopg2 requires the PostgreSQL libpq libraries and the pg_config utility

- virtualenv --distribute --no-site-packages venv

"""
import os
import subprocess
import re

here = os.path.dirname(os.path.abspath(__file__))
base_dir = os.path.dirname(here)
script_name = os.path.join(base_dir, 'blinkster-boot.py')

import virtualenv

# things to install
# - psycopg2 -> pip
# - PIL -> pip
# - pyxml -> pip
# - 4Suite-xml - easy_install ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2
# - pylucene  - script



EXTRA_TEXT = """

import shutil
import tarfile
import urllib

4SUITE_XML_URL = 'ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2'
PY_LUCENE_URL = 'http://apache.crihan.fr/dist/lucene/pylucene/pylucene-3.0.1-1-src.tar.gz'

def extend_parser(parser):
    pass

def adjust_options(options, args):
    if not args:
        return # caller will raise error
    
    # We're actually going to build the venv in a subdirectory
    base_dir = args[0]
    if len(args) > 1:
        venv_name = args[1]
    else:
        venv_name = "blinkster"
        
    args[0] = join(base_dir, venv_name)


def after_install(options, home_dir):
    base_dir = os.path.dirname(home_dir)
    src_dir = join(home_dir, 'src')
    tmp_dir = join(home_dir, 'tmp')
    ensure_dir(src_dir)
    ensure_dir(tmp_dir)
    #logger.indent += 2
    try:
        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), ,'-E '+ os.path.abspath(home_dir), 'psycopg2', 'pil', 'pyxml'],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), 4SUITE_XML_URL],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)

        #get pylucene
        pylucene_src = os.path.join(src_dir,"pylucene.tar.gz")
        urllib.urlretrieve(PY_LUCENE_URL, pylucene_src)
        tf = tarfile.open(pylucene_src,'r:gz')
        tf.extractall(os.path.join(src_dir,"pylucene"))
        tf.close()
        #install jcc
        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'python')), 'setup.py', 'install'],
                        cwd=os.path.abspath(os.path.join(src_dir,"pylucene","pylucene-3.0.1-1","jcc")),
                        filter_stdout=filter_python_develop,
                        show_stdout=False)
        #install pylucene       
        #modify makefile 
#PREFIX_PYTHON=os.path.abspath(fassembler_dir)
#ANT=ant
#PYTHON=$(PREFIX_PYTHON)/bin/python
#osx 10.5 10.6 32-64 bit
#JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386
#NUM_FILES=2

#linux 
#JCC=$(PYTHON) -m jcc --shared
#NUM_FILES=2

# windows
#JCC=$(PYTHON) -m jcc --shared
#NUM_FILES=3


#install pylucene
#delete src
        #call_subprocess([os.path.abspath(join(home_dir, 'bin', 'python')), 'setup.py', 'develop'],
        #                cwd=os.path.abspath(fassembler_dir),
        #                filter_stdout=filter_python_develop,
        #                show_stdout=False)
    finally:
        #logger.indent -= 2
    script_dir = join(base_dir, 'bin')
    logger.notify('Run "%s Package" to install new packages that provide builds'
                  % join(script_dir, 'easy_install'))

def ensure_dir(dir):
    if not os.path.exists(dir):
        logger.info('Creating directory %s' % dir)
        os.makedirs(dir)

def filter_python_develop(line):
    if not line.strip():
        return Logger.DEBUG
    for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                   'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                   'creating ', 'Copying ']:
        if line.startswith(prefix):
            return Logger.DEBUG
    return Logger.NOTIFY
"""

def main():
    python_version = ".".join(map(str,sys.version_info[0:2]))
    text = virtualenv.create_bootstrap_script(EXTRA_TEXT, python_version=python_version)
    if os.path.exists(script_name):
        f = open(script_name)
        cur_text = f.read()
        f.close()
    else:
        cur_text = ''
    print 'Updating %s' % script_name
    if cur_text == 'text':
        print 'No update'
    else:
        print 'Script changed; updating...'
        f = open(script_name, 'w')
        f.write(text)
        f.close()

if __name__ == '__main__':
    main()

