/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.AllTermDocs;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CloseableThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentReader
extends IndexReader
implements Cloneable {
    protected boolean readOnly;
    private SegmentInfo si;
    private int readBufferSize;
    CloseableThreadLocal<FieldsReader> fieldsReaderLocal = new FieldsReaderLocal();
    CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal();
    BitVector deletedDocs = null;
    Ref deletedDocsRef = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private int pendingDeleteCount;
    private boolean rollbackHasChanges = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private int rollbackPendingDeleteCount;
    private IndexInput singleNormStream;
    private Ref singleNormRef;
    CoreReaders core;
    Map<String, Norm> norms = new HashMap<String, Norm>();

    public static SegmentReader get(boolean readOnly, SegmentInfo si, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return SegmentReader.get(readOnly, si.dir, si, 1024, true, termInfosIndexDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SegmentReader get(boolean readOnly, Directory dir, SegmentInfo si, int readBufferSize, boolean doOpenStores, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        SegmentReader instance = readOnly ? new ReadOnlySegmentReader() : new SegmentReader();
        instance.readOnly = readOnly;
        instance.si = si;
        instance.readBufferSize = readBufferSize;
        boolean success = false;
        try {
            instance.core = new CoreReaders(dir, si, readBufferSize, termInfosIndexDivisor);
            if (doOpenStores) {
                instance.core.openDocStores(si);
            }
            instance.loadDeletedDocs();
            instance.openNorms(instance.core.cfsDir, readBufferSize);
            return instance;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (success) throw throwable;
            instance.doClose();
            throw throwable;
        }
    }

    void openDocStores() throws IOException {
        this.core.openDocStores(this.si);
    }

    private void loadDeletedDocs() throws IOException {
        if (SegmentReader.hasDeletions(this.si)) {
            this.deletedDocs = new BitVector(this.directory(), this.si.getDelFileName());
            this.deletedDocsRef = new Ref();
            assert (this.si.getDelCount() == this.deletedDocs.count()) : "delete count mismatch: info=" + this.si.getDelCount() + " vs BitVector=" + this.deletedDocs.count();
            assert (this.si.getDelCount() <= this.maxDoc()) : "delete count mismatch: " + this.deletedDocs.count() + ") exceeds max doc (" + this.maxDoc() + ") for segment " + this.si.name;
        } else assert (this.si.getDelCount() == 0);
    }

    protected byte[] cloneNormBytes(byte[] bytes) {
        byte[] cloneBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, cloneBytes, 0, bytes.length);
        return cloneBytes;
    }

    protected BitVector cloneDeletedDocs(BitVector bv) {
        return (BitVector)bv.clone();
    }

    @Override
    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, true, openReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized SegmentReader reopenSegment(SegmentInfo si, boolean doClone, boolean openReadOnly) throws CorruptIndexException, IOException {
        boolean deletionsUpToDate = this.si.hasDeletions() == si.hasDeletions() && (!si.hasDeletions() || this.si.getDelFileName().equals(si.getDelFileName()));
        boolean normsUpToDate = true;
        boolean[] fieldNormsChanged = new boolean[this.core.fieldInfos.size()];
        int fieldCount = this.core.fieldInfos.size();
        for (int i = 0; i < fieldCount; ++i) {
            if (this.si.getNormFileName(i).equals(si.getNormFileName(i))) continue;
            normsUpToDate = false;
            fieldNormsChanged[i] = true;
        }
        if (normsUpToDate && deletionsUpToDate && !doClone && openReadOnly && this.readOnly) {
            return this;
        }
        assert (!doClone || normsUpToDate && deletionsUpToDate);
        SegmentReader clone = openReadOnly ? new ReadOnlySegmentReader() : new SegmentReader();
        boolean success = false;
        try {
            this.core.incRef();
            clone.core = this.core;
            clone.readOnly = openReadOnly;
            clone.si = si;
            clone.readBufferSize = this.readBufferSize;
            if (!openReadOnly && this.hasChanges) {
                clone.pendingDeleteCount = this.pendingDeleteCount;
                clone.deletedDocsDirty = this.deletedDocsDirty;
                clone.normsDirty = this.normsDirty;
                clone.hasChanges = this.hasChanges;
                this.hasChanges = false;
            }
            if (doClone) {
                if (this.deletedDocs != null) {
                    this.deletedDocsRef.incRef();
                    clone.deletedDocs = this.deletedDocs;
                    clone.deletedDocsRef = this.deletedDocsRef;
                }
            } else if (!deletionsUpToDate) {
                assert (clone.deletedDocs == null);
                clone.loadDeletedDocs();
            } else if (this.deletedDocs != null) {
                this.deletedDocsRef.incRef();
                clone.deletedDocs = this.deletedDocs;
                clone.deletedDocsRef = this.deletedDocsRef;
            }
            clone.norms = new HashMap<String, Norm>();
            for (int i = 0; i < fieldNormsChanged.length; ++i) {
                String curField;
                Norm norm;
                if (!doClone && fieldNormsChanged[i] || (norm = this.norms.get(curField = this.core.fieldInfos.fieldInfo((int)i).name)) == null) continue;
                clone.norms.put(curField, (Norm)norm.clone());
            }
            clone.openNorms(si.getUseCompoundFile() ? this.core.getCFSReader() : this.directory(), this.readBufferSize);
            return clone;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (success) throw throwable;
            clone.decRef();
            throw throwable;
        }
    }

    @Override
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        if (this.hasChanges) {
            if (this.deletedDocsDirty) {
                this.si.advanceDelGen();
                this.deletedDocs.write(this.directory(), this.si.getDelFileName());
                this.si.setDelCount(this.si.getDelCount() + this.pendingDeleteCount);
                this.pendingDeleteCount = 0;
                assert (this.deletedDocs.count() == this.si.getDelCount()) : "delete count mismatch during commit: info=" + this.si.getDelCount() + " vs BitVector=" + this.deletedDocs.count();
            } else assert (this.pendingDeleteCount == 0);
            if (this.normsDirty) {
                this.si.setNumFields(this.core.fieldInfos.size());
                for (Norm norm : this.norms.values()) {
                    if (!norm.dirty) continue;
                    norm.reWrite(this.si);
                }
            }
            this.deletedDocsDirty = false;
            this.normsDirty = false;
            this.hasChanges = false;
        }
    }

    FieldsReader getFieldsReader() {
        return this.fieldsReaderLocal.get();
    }

    @Override
    protected void doClose() throws IOException {
        this.termVectorsLocal.close();
        this.fieldsReaderLocal.close();
        if (this.deletedDocs != null) {
            this.deletedDocsRef.decRef();
            this.deletedDocs = null;
        }
        for (Norm norm : this.norms.values()) {
            norm.decRef();
        }
        if (this.core != null) {
            this.core.decRef();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.hasDeletions();
    }

    @Override
    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        return si.hasSeparateNorms();
    }

    @Override
    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
            this.deletedDocsRef = new Ref();
        }
        if (this.deletedDocsRef.refCount() > 1) {
            Ref oldRef = this.deletedDocsRef;
            this.deletedDocs = this.cloneDeletedDocs(this.deletedDocs);
            this.deletedDocsRef = new Ref();
            oldRef.decRef();
        }
        this.deletedDocsDirty = true;
        if (!this.deletedDocs.getAndSet(docNum)) {
            ++this.pendingDeleteCount;
        }
    }

    @Override
    protected void doUndeleteAll() {
        this.deletedDocsDirty = false;
        if (this.deletedDocs != null) {
            assert (this.deletedDocsRef != null);
            this.deletedDocsRef.decRef();
            this.deletedDocs = null;
            this.deletedDocsRef = null;
            this.pendingDeleteCount = 0;
            this.si.clearDelGen();
            this.si.setDelCount(0);
        } else {
            assert (this.deletedDocsRef == null);
            assert (this.pendingDeleteCount == 0);
        }
    }

    List<String> files() throws IOException {
        return new ArrayList<String>(this.si.files());
    }

    @Override
    public TermEnum terms() {
        this.ensureOpen();
        return this.core.getTermsReader().terms();
    }

    @Override
    public TermEnum terms(Term t) throws IOException {
        this.ensureOpen();
        return this.core.getTermsReader().terms(t);
    }

    FieldInfos fieldInfos() {
        return this.core.fieldInfos;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.getFieldsReader().doc(n, fieldSelector);
    }

    @Override
    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        if (term == null) {
            return new AllTermDocs(this);
        }
        return super.termDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new SegmentTermDocs(this);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new SegmentTermPositions(this);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        TermInfo ti = this.core.getTermsReader().get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    @Override
    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    @Override
    public int maxDoc() {
        return this.si.docCount;
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.omitTermFreqAndPositions && fieldOption == IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    @Override
    public synchronized boolean hasNorms(String field) {
        this.ensureOpen();
        return this.norms.containsKey(field);
    }

    protected synchronized byte[] getNorms(String field) throws IOException {
        Norm norm = this.norms.get(field);
        if (norm == null) {
            return null;
        }
        return norm.bytes();
    }

    @Override
    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = this.getNorms(field);
        return bytes;
    }

    @Override
    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        Norm norm = this.norms.get(field);
        if (norm == null) {
            return;
        }
        this.normsDirty = true;
        norm.copyOnWrite()[doc] = value;
    }

    @Override
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        this.ensureOpen();
        Norm norm = this.norms.get(field);
        if (norm == null) {
            Arrays.fill(bytes, offset, bytes.length, DefaultSimilarity.encodeNorm(1.0f));
            return;
        }
        norm.bytes(bytes, offset, this.maxDoc());
    }

    private void openNorms(Directory cfsDir, int readBufferSize) throws IOException {
        long nextNormSeek = SegmentMerger.NORMS_HEADER.length;
        int maxDoc = this.maxDoc();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            long normSeek;
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (this.norms.containsKey(fi.name) || !fi.isIndexed || fi.omitNorms) continue;
            Directory d = this.directory();
            String fileName = this.si.getNormFileName(fi.number);
            if (!this.si.hasSeparateNorms(fi.number)) {
                d = cfsDir;
            }
            boolean singleNormFile = fileName.endsWith(".nrm");
            IndexInput normInput = null;
            if (singleNormFile) {
                normSeek = nextNormSeek;
                if (this.singleNormStream == null) {
                    this.singleNormStream = d.openInput(fileName, readBufferSize);
                    this.singleNormRef = new Ref();
                } else {
                    this.singleNormRef.incRef();
                }
                normInput = this.singleNormStream;
            } else {
                normSeek = 0L;
                normInput = d.openInput(fileName);
            }
            this.norms.put(fi.name, new Norm(normInput, fi.number, normSeek));
            nextNormSeek += (long)maxDoc;
        }
    }

    boolean termsIndexLoaded() {
        return this.core.termsIndexIsLoaded();
    }

    void loadTermsIndex(int termsIndexDivisor) throws IOException {
        this.core.loadTermsIndex(this.si, termsIndexDivisor);
    }

    boolean normsClosed() {
        if (this.singleNormStream != null) {
            return false;
        }
        for (Norm norm : this.norms.values()) {
            if (norm.refCount <= 0) continue;
            return false;
        }
        return true;
    }

    boolean normsClosed(String field) {
        return this.norms.get(field).refCount == 0;
    }

    TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = this.termVectorsLocal.get();
        if (tvReader == null) {
            TermVectorsReader orig = this.core.getTermVectorsReaderOrig();
            if (orig == null) {
                return null;
            }
            try {
                tvReader = (TermVectorsReader)orig.clone();
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    TermVectorsReader getTermVectorsReaderOrig() {
        return this.core.getTermVectorsReaderOrig();
    }

    @Override
    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, field, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, mapper);
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    public String getSegmentName() {
        return this.core.segment;
    }

    SegmentInfo getSegmentInfo() {
        return this.si;
    }

    void setSegmentInfo(SegmentInfo info) {
        this.si = info;
    }

    void startCommit() {
        this.rollbackHasChanges = this.hasChanges;
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackPendingDeleteCount = this.pendingDeleteCount;
        for (Norm norm : this.norms.values()) {
            norm.rollbackDirty = norm.dirty;
        }
    }

    void rollbackCommit() {
        this.hasChanges = this.rollbackHasChanges;
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.pendingDeleteCount = this.rollbackPendingDeleteCount;
        for (Norm norm : this.norms.values()) {
            norm.dirty = norm.rollbackDirty;
        }
    }

    @Override
    public Directory directory() {
        return this.core.dir;
    }

    @Override
    public final Object getFieldCacheKey() {
        return this.core.freqStream;
    }

    @Override
    public long getUniqueTermCount() {
        return this.core.getTermsReader().size();
    }

    static SegmentReader getOnlySegmentReader(Directory dir) throws IOException {
        return SegmentReader.getOnlySegmentReader(IndexReader.open(dir, false));
    }

    static SegmentReader getOnlySegmentReader(IndexReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof DirectoryReader) {
            IndexReader[] subReaders = reader.getSequentialSubReaders();
            if (subReaders.length != 1) {
                throw new IllegalArgumentException(reader + " has " + subReaders.length + " segments instead of exactly one");
            }
            return (SegmentReader)subReaders[0];
        }
        throw new IllegalArgumentException(reader + " is not a SegmentReader or a single-segment DirectoryReader");
    }

    @Override
    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    final class Norm
    implements Cloneable {
        private int refCount = 1;
        private Norm origNorm;
        private IndexInput in;
        private long normSeek;
        private Ref bytesRef;
        private byte[] bytes;
        private boolean dirty;
        private int number;
        private boolean rollbackDirty;

        public Norm(IndexInput in, int number, long normSeek) {
            this.in = in;
            this.number = number;
            this.normSeek = normSeek;
        }

        public synchronized void incRef() {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            ++this.refCount;
        }

        private void closeInput() throws IOException {
            if (this.in != null) {
                if (this.in != SegmentReader.this.singleNormStream) {
                    this.in.close();
                } else if (SegmentReader.this.singleNormRef.decRef() == 0) {
                    SegmentReader.this.singleNormStream.close();
                    SegmentReader.this.singleNormStream = null;
                }
                this.in = null;
            }
        }

        public synchronized void decRef() throws IOException {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            if (--this.refCount == 0) {
                if (this.origNorm != null) {
                    this.origNorm.decRef();
                    this.origNorm = null;
                } else {
                    this.closeInput();
                }
                if (this.bytes != null) {
                    assert (this.bytesRef != null);
                    this.bytesRef.decRef();
                    this.bytes = null;
                    this.bytesRef = null;
                } else assert (this.bytesRef == null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void bytes(byte[] bytesOut, int offset, int len) throws IOException {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            if (this.bytes != null) {
                assert (len <= SegmentReader.this.maxDoc());
                System.arraycopy(this.bytes, 0, bytesOut, offset, len);
            } else if (this.origNorm != null) {
                this.origNorm.bytes(bytesOut, offset, len);
            } else {
                IndexInput indexInput = this.in;
                synchronized (indexInput) {
                    this.in.seek(this.normSeek);
                    this.in.readBytes(bytesOut, offset, len, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized byte[] bytes() throws IOException {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            if (this.bytes == null) {
                assert (this.bytesRef == null);
                if (this.origNorm != null) {
                    this.bytes = this.origNorm.bytes();
                    this.bytesRef = this.origNorm.bytesRef;
                    this.bytesRef.incRef();
                    this.origNorm.decRef();
                    this.origNorm = null;
                } else {
                    int count = SegmentReader.this.maxDoc();
                    this.bytes = new byte[count];
                    assert (this.in != null);
                    IndexInput indexInput = this.in;
                    synchronized (indexInput) {
                        this.in.seek(this.normSeek);
                        this.in.readBytes(this.bytes, 0, count, false);
                    }
                    this.bytesRef = new Ref();
                    this.closeInput();
                }
            }
            return this.bytes;
        }

        Ref bytesRef() {
            return this.bytesRef;
        }

        public synchronized byte[] copyOnWrite() throws IOException {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            this.bytes();
            assert (this.bytes != null);
            assert (this.bytesRef != null);
            if (this.bytesRef.refCount() > 1) {
                assert (this.refCount == 1);
                Ref oldRef = this.bytesRef;
                this.bytes = SegmentReader.this.cloneNormBytes(this.bytes);
                this.bytesRef = new Ref();
                oldRef.decRef();
            }
            this.dirty = true;
            return this.bytes;
        }

        public synchronized Object clone() {
            Norm clone;
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
            try {
                clone = (Norm)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException("unexpected CloneNotSupportedException", cnse);
            }
            clone.refCount = 1;
            if (this.bytes != null) {
                assert (this.bytesRef != null);
                assert (this.origNorm == null);
                clone.bytesRef.incRef();
            } else {
                assert (this.bytesRef == null);
                if (this.origNorm == null) {
                    clone.origNorm = this;
                }
                clone.origNorm.incRef();
            }
            clone.in = null;
            return clone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reWrite(SegmentInfo si) throws IOException {
            assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0)) : "refCount=" + this.refCount + " origNorm=" + this.origNorm;
            si.advanceNormGen(this.number);
            IndexOutput out = SegmentReader.this.directory().createOutput(si.getNormFileName(this.number));
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                out.close();
                throw throwable;
            }
            out.close();
            this.dirty = false;
        }
    }

    static class Ref {
        private int refCount = 1;

        Ref() {
        }

        public String toString() {
            return "refcount: " + this.refCount;
        }

        public synchronized int refCount() {
            return this.refCount;
        }

        public synchronized int incRef() {
            assert (this.refCount > 0);
            ++this.refCount;
            return this.refCount;
        }

        public synchronized int decRef() {
            assert (this.refCount > 0);
            --this.refCount;
            return this.refCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldsReaderLocal
    extends CloseableThreadLocal<FieldsReader> {
        private FieldsReaderLocal() {
        }

        @Override
        protected FieldsReader initialValue() {
            return (FieldsReader)SegmentReader.this.core.getFieldsReaderOrig().clone();
        }
    }

    static final class CoreReaders {
        private final Ref ref = new Ref();
        final String segment;
        final FieldInfos fieldInfos;
        final IndexInput freqStream;
        final IndexInput proxStream;
        final TermInfosReader tisNoIndex;
        final Directory dir;
        final Directory cfsDir;
        final int readBufferSize;
        final int termsIndexDivisor;
        TermInfosReader tis;
        FieldsReader fieldsReaderOrig;
        TermVectorsReader termVectorsReaderOrig;
        CompoundFileReader cfsReader;
        CompoundFileReader storeCFSReader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        CoreReaders(Directory dir, SegmentInfo si, int readBufferSize, int termsIndexDivisor) throws IOException {
            this.segment = si.name;
            this.readBufferSize = readBufferSize;
            this.dir = dir;
            boolean success = false;
            try {
                Directory dir0 = dir;
                if (si.getUseCompoundFile()) {
                    this.cfsReader = new CompoundFileReader(dir, this.segment + "." + "cfs", readBufferSize);
                    dir0 = this.cfsReader;
                }
                this.cfsDir = dir0;
                this.fieldInfos = new FieldInfos(this.cfsDir, this.segment + "." + "fnm");
                this.termsIndexDivisor = termsIndexDivisor;
                TermInfosReader reader = new TermInfosReader(this.cfsDir, this.segment, this.fieldInfos, readBufferSize, termsIndexDivisor);
                if (termsIndexDivisor == -1) {
                    this.tisNoIndex = reader;
                } else {
                    this.tis = reader;
                    this.tisNoIndex = null;
                }
                this.freqStream = this.cfsDir.openInput(this.segment + "." + "frq", readBufferSize);
                this.proxStream = this.fieldInfos.hasProx() ? this.cfsDir.openInput(this.segment + "." + "prx", readBufferSize) : null;
                success = true;
                Object var9_8 = null;
                if (success) return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (success) throw throwable;
                this.decRef();
                throw throwable;
            }
            this.decRef();
        }

        synchronized TermVectorsReader getTermVectorsReaderOrig() {
            return this.termVectorsReaderOrig;
        }

        synchronized FieldsReader getFieldsReaderOrig() {
            return this.fieldsReaderOrig;
        }

        synchronized void incRef() {
            this.ref.incRef();
        }

        synchronized Directory getCFSReader() {
            return this.cfsReader;
        }

        synchronized TermInfosReader getTermsReader() {
            if (this.tis != null) {
                return this.tis;
            }
            return this.tisNoIndex;
        }

        synchronized boolean termsIndexIsLoaded() {
            return this.tis != null;
        }

        synchronized void loadTermsIndex(SegmentInfo si, int termsIndexDivisor) throws IOException {
            if (this.tis == null) {
                Directory dir0;
                if (si.getUseCompoundFile()) {
                    if (this.cfsReader == null) {
                        this.cfsReader = new CompoundFileReader(this.dir, this.segment + "." + "cfs", this.readBufferSize);
                    }
                    dir0 = this.cfsReader;
                } else {
                    dir0 = this.dir;
                }
                this.tis = new TermInfosReader(dir0, this.segment, this.fieldInfos, this.readBufferSize, termsIndexDivisor);
            }
        }

        synchronized void decRef() throws IOException {
            if (this.ref.decRef() == 0) {
                if (this.tis != null) {
                    this.tis.close();
                    this.tis = null;
                }
                if (this.tisNoIndex != null) {
                    this.tisNoIndex.close();
                }
                if (this.freqStream != null) {
                    this.freqStream.close();
                }
                if (this.proxStream != null) {
                    this.proxStream.close();
                }
                if (this.termVectorsReaderOrig != null) {
                    this.termVectorsReaderOrig.close();
                }
                if (this.fieldsReaderOrig != null) {
                    this.fieldsReaderOrig.close();
                }
                if (this.cfsReader != null) {
                    this.cfsReader.close();
                }
                if (this.storeCFSReader != null) {
                    this.storeCFSReader.close();
                }
            }
        }

        synchronized void openDocStores(SegmentInfo si) throws IOException {
            assert (si.name.equals(this.segment));
            if (this.fieldsReaderOrig == null) {
                Directory storeDir;
                if (si.getDocStoreOffset() != -1) {
                    if (si.getDocStoreIsCompoundFile()) {
                        assert (this.storeCFSReader == null);
                        this.storeCFSReader = new CompoundFileReader(this.dir, si.getDocStoreSegment() + "." + "cfx", this.readBufferSize);
                        storeDir = this.storeCFSReader;
                        assert (storeDir != null);
                    } else {
                        storeDir = this.dir;
                        assert (storeDir != null);
                    }
                } else if (si.getUseCompoundFile()) {
                    if (this.cfsReader == null) {
                        this.cfsReader = new CompoundFileReader(this.dir, this.segment + "." + "cfs", this.readBufferSize);
                    }
                    storeDir = this.cfsReader;
                    assert (storeDir != null);
                } else {
                    storeDir = this.dir;
                    assert (storeDir != null);
                }
                String storesSegment = si.getDocStoreOffset() != -1 ? si.getDocStoreSegment() : this.segment;
                this.fieldsReaderOrig = new FieldsReader(storeDir, storesSegment, this.fieldInfos, this.readBufferSize, si.getDocStoreOffset(), si.docCount);
                if (si.getDocStoreOffset() == -1 && this.fieldsReaderOrig.size() != si.docCount) {
                    throw new CorruptIndexException("doc counts differ for segment " + this.segment + ": fieldsReader shows " + this.fieldsReaderOrig.size() + " but segmentInfo shows " + si.docCount);
                }
                if (this.fieldInfos.hasVectors()) {
                    this.termVectorsReaderOrig = new TermVectorsReader(storeDir, storesSegment, this.fieldInfos, this.readBufferSize, si.getDocStoreOffset(), si.docCount);
                }
            }
        }
    }
}

