# -*- coding: utf-8 -*-
from django import forms
from blinkster.ldt.models import *

class LdtImportForm(forms.Form):
    importFile = forms.FileField()
    author = forms.ModelChoiceField(Author.objects.all())

class SearchForm(forms.Form):
    search = forms.CharField()
    field = forms.ChoiceField([(u"all",u"tous"),(u"title",u"titre"),(u"abstract",u"résumé"),(u"tags",u"tags")])

class LdtForm(forms.Form):
    contents = forms.ModelMultipleChoiceField(Content.objects.all())
    author = forms.ModelChoiceField(Author.objects.all())

class reindexForm(forms.Form):
    contents = forms.ModelMultipleChoiceField(Content.objects.all())

class LdtProjectImportForm(forms.Form):
    importFile = forms.FileField()
    author = forms.ModelChoiceField(Author.objects.all())

