##
## log.py
## Login : <ymh@illuvatar>
## Started on  Thu Aug  7 22:25:45 2008 Yves-Marie Haussonne
## $Id$
## 
## Copyright (C) 2008 Yves-Marie Haussonne
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##

import logging
from django.conf import settings

class Log:
    
    class __impl(object):
        __logger = None
        def __init__(self):
            self.__logger = logging.getLogger("django")
            hdlr = logging.FileHandler(settings.LOG_FILE)
            formatter = logging.Formatter('[%(asctime)s]%(levelname)-8s"%(message)s"', '%Y-%m-%d %a %H:%M:%S') 
            hdlr.setFormatter(formatter)
            self.__logger.addHandler(hdlr)
            self.__logger.setLevel(settings.LOG_LEVEL)

        def debug(self, msg):
            self.__logger.debug(msg)
    
    __instance = None
    
    def __init__(self):
        """ Create singleton instance """
        # Check whether we already have an instance
        if Log.__instance is None:
            # Create and remember instance
            Log.__instance = Log.__impl()

        # Store instance reference as the only member in the handle
        self.__dict__['_Log__instance'] = Log.__instance

    def __getattr__(self, attr):
        """ Delegate access to implementation """
        return getattr(self.__instance, attr)

    def __setattr__(self, attr, value):
        """ Delegate access to implementation """
        return setattr(self.__instance, attr, value)
    
def debug(msg):
    Log().debug(msg)
    
