"""
Call this like ``python create_python_env.py``; it will
refresh the blinkster-boot.py script

-prerequisite:

- virtualenv
- distribute
- psycopg2 requires the PostgreSQL libpq libraries and the pg_config utility

- virtualenv --distribute --no-site-packages venv
- python blinkster-boot.py --distribute --no-site-packages --index-url=http://pypi.websushi.org/ --clear bvenv

"""

import os
import subprocess
import re
import sys


here = os.path.dirname(os.path.abspath(__file__))
base_dir = here
script_name = os.path.join(base_dir, 'blinkster-boot.py')

import virtualenv

# things to install
# - psycopg2 -> pip
# - PIL -> pip
# - pyxml -> pip
# - 4Suite-xml - easy_install ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2
# - pylucene  - script

src_base = os.path.join(here,"res","src")
lib_path = os.path.abspath(os.path.join(here,"res","lib"))
patch_path = os.path.abspath(os.path.join(here,"res","patch"))

EXTRA_TEXT  = "URLS = { \n"

EXTRA_TEXT += "    'PSYCOPG2' : { 'url': 'http://initd.org/pub/software/psycopg/psycopg2-2.2.1.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"psycopg2-2.2.1.tar.gz"))+"'},\n"
EXTRA_TEXT += "    'FOURSUITE_XML' : { 'url': 'ftp://ftp.4suite.org/pub/4Suite/4Suite-XML-1.0.2.tar.bz2', 'local': '"+ os.path.abspath(os.path.join(src_base,"4Suite-XML-1.0.2.tar.bz2"))+"'},\n"
EXTRA_TEXT += "    'PYLUCENE' : { 'url': 'http://apache.crihan.fr/dist/lucene/pylucene/pylucene-3.0.1-1-src.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"pylucene-3.0.1-1-src.tar.gz"))+"'},\n"
EXTRA_TEXT += "    'PIL' : { 'url': 'http://effbot.org/downloads/Imaging-1.1.7.tar.gz', 'local': '"+ os.path.abspath(os.path.join(src_base,"Imaging-1.1.7.tar.gz"))+"'},\n"
EXTRA_TEXT += "    'PYXML' : { 'url': 'http://sourceforge.net/projects/pyxml/files/pyxml/0.8.4/PyXML-0.8.4.tar.gz/download', 'local': '"+ os.path.abspath(os.path.join(src_base,"PyXML-0.8.4.tar.gz"))+"', 'patch': '"+os.path.join(patch_path,"pyxml.patch")+"'},\n"

EXTRA_TEXT += "}\n"

EXTRA_TEXT += "import sys\n"
EXTRA_TEXT += "sys.path.append('"+lib_path+"')\n"

EXTRA_TEXT += """

import shutil
import tarfile
import urllib
import platform
import patch


INDEX_URL = 'http://pypi.python.org/simple/'


def extend_parser(parser):
    parser.add_option(
        '--index-url',
        metavar='INDEX_URL',
        dest='index_url',
        default='',
        help='base URL of Python Package Index')
    parser.add_option(
        '--local',
        metavar='LOCAL',
        dest='local',
        action="store_true",
        default=False,
        help='base URL of Python Package Index')


def adjust_options(options, args):
    pass


def after_install(options, home_dir):
    base_dir = os.path.dirname(home_dir)
    src_dir = join(home_dir, 'src')
    tmp_dir = join(home_dir, 'tmp')
    ensure_dir(src_dir)
    ensure_dir(tmp_dir)
    
    res_source_key = "local" if options.local else "url"
    
    logger.indent += 2
    try:
        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), URLS['PSYCOPG2'][res_source_key]],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)

        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), URLS['PIL'][res_source_key]],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)

        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), URLS['FOURSUITE_XML'][res_source_key]],
                        cwd=os.path.abspath(tmp_dir),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)

        
        if sys.version_info >= (2,6):
            pyxml_src = os.path.join(src_dir,"pyxml.tar.gz")
            urllib.urlretrieve(URLS['PYXML'][res_source_key], pyxml_src)
            tf = tarfile.open(pyxml_src,'r:gz')
            pyxml_base_path = os.path.join(src_dir,"pyxml") 
            tf.extractall(pyxml_base_path)
            tf.close()
            #patch
            pyxml_version = os.listdir(pyxml_base_path)[0]            
            pyxml_path = os.path.join(pyxml_base_path, pyxml_version)
            olddir = os.getcwd()
            os.chdir(pyxml_path)
            p = patch.fromfile(URLS['PYXML']['patch'])
            p.apply()
            os.chdir(olddir)
            call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), '--build='+os.path.abspath(pyxml_base_path), '--no-download', pyxml_version],
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True)
        else:
            call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), URLS['PYXML'][res_source_key]],
                    cwd=os.path.abspath(tmp_dir),
                    filter_stdout=filter_python_develop,
                    show_stdout=True)
        

        #get pylucene
        pylucene_src = os.path.join(src_dir,"pylucene.tar.gz")
        urllib.urlretrieve(URLS['PYLUCENE'][res_source_key], pylucene_src)
        tf = tarfile.open(pylucene_src,'r:gz')
        pylucene_base_path = os.path.join(src_dir,"pylucene") 
        tf.extractall(pylucene_base_path)
        tf.close()
        
        pylucene_src_path = os.path.join(pylucene_base_path, os.listdir(pylucene_base_path)[0])
        
        #install jcc
        call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'python')), 'setup.py', 'install'],
                        cwd=os.path.abspath(os.path.join(pylucene_src_path,"jcc")),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
        #install pylucene       
        #modify makefile
        makefile_path = os.path.join(pylucene_src_path,"Makefile")
        shutil.move( makefile_path, makefile_path+"~" )

        destination= open( makefile_path, "w" )
        source= open( makefile_path+"~", "r" )
        destination.write("PREFIX_PYTHON="+os.path.abspath(home_dir)+"\\n")
        destination.write("ANT=ant\\n")
        destination.write("PYTHON=$(PREFIX_PYTHON)/bin/python\\n")
        system_str = platform.system()
        if system_str == "Darwin":
            if sys.version_info >= (2,6):
                destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
            else:
                destination.write("JCC=$(PYTHON) -m jcc --shared\\n")
            destination.write("NUM_FILES=2\\n")
        elif system_str == "Windows":
            destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
            destination.write("NUM_FILES=2\\n")
        else:
            destination.write("JCC=$(PYTHON) -m jcc --shared\\n")
            destination.write("NUM_FILES=2\\n")
        for line in source:
            destination.write( line )
        source.close()
        destination.close()
        os.remove(makefile_path+"~" )

        call_subprocess(['make'],
                        cwd=os.path.abspath(pylucene_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)

        call_subprocess(['make', 'install'],
                        cwd=os.path.abspath(pylucene_src_path),
                        filter_stdout=filter_python_develop,
                        show_stdout=True)
        shutil.rmtree(src_dir)

    finally:
        logger.indent -= 2
    script_dir = join(base_dir, 'bin')
    logger.notify('Run "%s Package" to install new packages that provide builds'
                  % join(script_dir, 'easy_install'))

def ensure_dir(dir):
    if not os.path.exists(dir):
        logger.info('Creating directory %s' % dir)
        os.makedirs(dir)

def filter_python_develop(line):
    if not line.strip():
        return Logger.DEBUG
    for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                   'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                   'creating ', 'Copying ']:
        if line.startswith(prefix):
            return Logger.DEBUG
    return Logger.NOTIFY
"""

def main():
    python_version = ".".join(map(str,sys.version_info[0:2]))
    text = virtualenv.create_bootstrap_script(EXTRA_TEXT, python_version=python_version)
    if os.path.exists(script_name):
        f = open(script_name)
        cur_text = f.read()
        f.close()
    else:
        cur_text = ''
    print 'Updating %s' % script_name
    if cur_text == 'text':
        print 'No update'
    else:
        print 'Script changed; updating...'
        f = open(script_name, 'w')
        f.write(text)
        f.close()

if __name__ == '__main__':
    main()

