# Create your views here.
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render_to_response
from django.core.urlresolvers import reverse
from django.template import RequestContext, TemplateDoesNotExist
from django.template.loader import get_template
from django.core import serializers
from django.core.serializers.json import DjangoJSONEncoder
from django.utils import simplejson

from blinkster.models import Roi
import blinkster

def roi(request):
    response = HttpResponse(content_type="application/json; charset=utf-8")
    objs = {
        "version" : blinkster.VERSION,
        "rois" : [roi.serialize_to_dict() for roi in Roi.objects.all()]
    }
    simplejson.dump(objs, response, cls=DjangoJSONEncoder,ensure_ascii=False, indent=4)
    return response
