from django.conf import settings
from django.contrib.auth.models import User, Group
from django.contrib.contenttypes.models import ContentType
from django.core.exceptions import ObjectDoesNotExist
from django.db.models import signals
from ldt.core.models import Owner
from ldt.user.models import ldt, IriGroup
# import logging

    
def post_save_ldt(instance, raw, created, **kwargs):
    signals.post_save.send(sender=User, instance=instance, raw=raw, created=created)     
    
signals.post_save.connect(post_save_ldt, ldt) 

def post_save_irigroup(instance, raw, created, **kwargs):
    signals.post_save.send(sender=Group, instance=instance, raw=raw, created=created)
    
signals.post_save.connect(post_save_irigroup, IriGroup) 

def post_save_user(instance, raw, created, **kwargs):
    if created:
        try:
            owner = Owner.objects.get(user=instance)
        except ObjectDoesNotExist:
            owner = Owner(user=instance)
            owner.save() 
    
signals.post_save.connect(post_save_user, User) 

def post_save_group(instance, raw, created, **kwargs):
    if created:
        try:
            owner = Owner.objects.get(group=instance)
        except ObjectDoesNotExist:
            owner = Owner(group=instance)
            owner.save()
    
signals.post_save.connect(post_save_group, Group) 

    
def test_cms():
    if 'cms' in settings.INSTALLED_APPS:
        return True
    else:
        return False
        
def test_ldt():
    if 'ldt.ldt_utils' in settings.INSTALLED_APPS:
        return True
    else:
        return False

def get_content_type_list() :
    content_type_list = []
    if test_cms():
        content_type = ContentType.objects.get(app_label='cms', model='page')
        content_type_list.append(content_type)
        content_type = ContentType.objects.get(app_label='snippet', model='snippet')
        content_type_list.append(content_type)
    # if test_ldt():
        # content_type = ContentType.objects.get(app_label='ldt', model='content')
        # content_type_list.append(content_type)
    return content_type_list


