#From Daniel Chudnov <daniel.chudnov@yale.edu>

import os
from Xml.Xslt import test_harness

source_1 = """<?xml version="1.0" encoding="ISO-8859-1"?>
<search><request type="title"><terms trunc="on">jama</terms><year>2000</year><searchurl>http://jake.med.yale.edu/search.php3</searchurl><dataurl>http://jake.med.yale.edu/cgi-bin/getxml.pl</dataurl></request><results><authrecord><title>Journal of the American Medical Association</title><id jakeid="4609" type="serial"/><serialinfo issn="0098-7484"/><subjects><subject classtype="dewey" source="lc">610/.5.19</subject><subject classtype="lc" source="lc">R15.A48</subject><subject classtype="lcsh" source="lc">American Medical Association</subject><subject classtype="lcsh" source="lc">Medicine</subject><subject classtype="lcsh" source="lc">Medicine</subject></subjects><database jakeid="22703" authrelid="182544"><title>Academic Abstracts FullTEXT Elite</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="22711" authrelid="183466"><title>Academic Abstracts FullTEXT Ultra</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="19407" authrelid="130042"><title>Academic ASAP</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1996-01-01">1/1996</start></cites><fulltext><start date="1996-01-01">1/1996</start></fulltext></database><database jakeid="22712" authrelid="185308"><title>Academic Search Elite</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="9583" authrelid="127226"><title>Agricola</title><providername jakeid="9580">Ovid</providername><preferredtitle>Jama: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9667" authrelid="2810"><title>AIDS and Cancer Research</title><providername jakeid="19225">OCLC</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="10423" authrelid="5673"><title>BasicBIOSIS</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA (Journal of the American Medical Association)</preferredtitle><cites/></database><database jakeid="9590" authrelid="108628"><title>Bioethicsline</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9591" authrelid="58654"><title>Biosis</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9595" authrelid="118949"><title>CAB Abstracts</title><providername jakeid="9580">Ovid</providername><preferredtitle>JAMA, Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="22716" authrelid="191101"><title>Canadian MAS FullTEXT Elite</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="11621" authrelid="6941"><title>Chemical Abstracts Student Edition</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA, the Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9598" authrelid="74031"><title>CINAHL</title><providername jakeid="9580">Ovid</providername><preferredtitle>Jama: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="22718" authrelid="192807"><title>Corporate ResourceNet (CRN)</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="9596" authrelid="66053"><title>Current Contents</title><providername jakeid="9580">Ovid</providername><preferredtitle>Jama: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9601" authrelid="104480"><title>Embase</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="11875" authrelid="10161"><title>Environmental Sciences and Pollution Management</title><providername jakeid="19225">OCLC</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9602" authrelid="102971"><title>ERIC</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="19414" authrelid="136020"><title>Expanded Academic ASAP</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1996-01-01">1/1996</start></cites><fulltext><start date="1996-01-01">1/1996</start></fulltext></database><database jakeid="19415" authrelid="138084"><title>Expanded Academic ASAP -- International</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1996-01-01">1/1996</start></cites><fulltext><start date="1996-01-01">1/1996</start></fulltext></database><database jakeid="19421" authrelid="143313"><title>General Reference Center</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1995-01-01">1/1995</start></cites><fulltext><start date="1995-01-01">1/1995</start></fulltext></database><database jakeid="19422" authrelid="144434"><title>General Reference Center Gold</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1995-01-01">1/1995</start></cites><fulltext><start date="1995-01-01">1/1995</start></fulltext></database><database jakeid="19423" authrelid="145443"><title>General Reference Center Select</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1987-01-01">1/1987</start></cites><fulltext><start date="1987-12-01">12/1987</start></fulltext></database><database jakeid="19424" authrelid="146158"><title>General Reference Centre -- International</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1995-01-01">1/1995</start></cites><fulltext><start date="1995-01-01">1/1995</start></fulltext></database><database jakeid="9605" authrelid="94195"><title>General Science Index/Abstracts</title><providername jakeid="19399">Wilson</providername><preferredtitle>JAMA</preferredtitle><cites/></database><database jakeid="12749" authrelid="12339"><title>General Sciences Abstracts</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA</preferredtitle><cites><start date="1984-08-01">Aug-84</start></cites></database><database jakeid="19425" authrelid="146944"><title>Health Reference Center</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1995-01-01">1/1995</start></cites><fulltext><start date="1995-01-01">1/1995</start></fulltext></database><database jakeid="19426" authrelid="147158"><title>Health Reference Center -- Academic</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1995-01-01">1/1995</start></cites><fulltext><start date="1995-01-01">1/1995</start></fulltext></database><database jakeid="22720" authrelid="194267"><title>Health Source</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="22721" authrelid="194622"><title>Health Source Plus</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="9610" authrelid="101127"><title>INSPEC</title><providername jakeid="9580">Ovid</providername><preferredtitle>JAMA</preferredtitle><cites/></database><database jakeid="9604" authrelid="97267"><title>International Humanities and Social Science</title><providername jakeid="19397">RLG</providername><preferredtitle>JAMA, The Journal Of The American Medical Association</preferredtitle><cites/></database><database jakeid="9611" authrelid="110812"><title>International Pharmaceutical Abstracts</title><providername jakeid="9580">Ovid</providername><preferredtitle>JAMA</preferredtitle><cites/></database><database jakeid="9581" authrelid="51346"><title>Journals@Ovid</title><providername jakeid="9580">Ovid</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites/><fulltext><issuelist><urlpattern><baseurl default="http://www.ovid.com/"/>ovidweb/jslogin.cgi?T=JS&amp;MODE=ovid&amp;D=ovid_ovft&amp;SEARCH=JAMA:%20Journal%20of%20the%20American%20Medical%20Association.jn.+and+<volume/>.vo.+and+<issue/>.ip.+and+<page/>.pg.&amp;PAGE=titles</urlpattern></issuelist><article><urlpattern><baseurl default="http://www.ovid.com/"/>ovidweb/jslogin.cgi?T=JS&amp;MODE=ovid&amp;D=ovid_ovft&amp;SEARCH=JAMA:%20Journal%20of%20the%20American%20Medical%20Association.jn.+and+<volume/>.vo.+and+<issue/>.ip.+and+<page/>.pg.&amp;PAGE=titles</urlpattern></article><toc><urlpattern><baseurl default="http://www.ovid.com/"/>ovidweb/jslogin.cgi?T=JS&amp;MODE=ovid&amp;D=ovid_ovft&amp;SEARCH=JAMA:%20Journal%20of%20the%20American%20Medical%20Association.jn.+and+<volume/>.vo.+and+<issue/>.ip.+and+<page/>.pg.&amp;PAGE=titles</urlpattern></toc><start date="1993-01-01">January-1993</start></fulltext></database><database jakeid="23017" authrelid="195147"><title>MAS FullTEXT Elite</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23018" authrelid="195642"><title>MAS FullTEXT Premier</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23019" authrelid="196142"><title>MAS FullTEXT Select</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23020" authrelid="196715"><title>MAS FullTEXT Ultra</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23021" authrelid="197148"><title>MAS Online</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23022" authrelid="197465"><title>MAS Online Plus</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23023" authrelid="197895"><title>MAS Ultra - Public Library Edition</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23024" authrelid="199490"><title>MasterFILE Elite</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23026" authrelid="202217"><title>MasterFILE Premier</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="23025" authrelid="205016"><title>MasterFILE Select</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites><start date="1989-01-01">01/01/89</start></cites></database><database jakeid="9617" authrelid="77393"><title>Medline</title><providername jakeid="9580">Ovid</providername><preferredtitle>JAMA</preferredtitle><cites/></database><database jakeid="23028" authrelid="206995"><title>Military Library FullTEXT</title><providername jakeid="21072">EBSCO Industries</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9618" authrelid="112422"><title>MLA International Bibliography</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="14606" authrelid="23034"><title>OCLC ArticleFirst</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA : the journal of the American Medical Association.</preferredtitle><cites/></database><database jakeid="16827" authrelid="45057"><title>OCLC ContentsFirst</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA : the journal of the American Medical Association.</preferredtitle><cites/></database><database jakeid="18576" authrelid="33470"><title>Periodical Abstracts</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA: The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">01/03/1986</start></cites></database><database jakeid="20585" authrelid="154443"><title>Periodical Abstracts Library</title><providername jakeid="20577">Proquest</providername><preferredtitle>JAMA; The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">1/3/86</start><end>current</end></cites><fulltext><start date="1995-12-20">12/20/95</start><end>current</end></fulltext></database><database jakeid="20586" authrelid="155282"><title>Periodical Abstracts Research I</title><providername jakeid="20577">Proquest</providername><preferredtitle>JAMA; The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">1/3/86</start><end>current</end></cites><fulltext><start date="1995-12-20">12/20/95</start><end>current</end></fulltext></database><database jakeid="9619" authrelid="114257"><title>Periodical Abstracts Research II</title><providername jakeid="9580">Ovid</providername><preferredtitle>Jama: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="20587" authrelid="156788"><title>Periodical Abstracts Research II</title><providername jakeid="20577">Proquest</providername><preferredtitle>JAMA; The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">1/3/86</start><end>current</end></cites><fulltext><start date="1995-12-20">12/20/95</start><end>current</end></fulltext></database><database jakeid="20589" authrelid="159999"><title>ProQuest 5000</title><providername jakeid="20577">Proquest</providername><preferredtitle>JAMA; The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">1/3/86</start><end>current</end></cites><fulltext><start date="1995-12-20">12/20/95</start><end>current</end></fulltext></database><database jakeid="9621" authrelid="81707"><title>PsycInfo</title><providername jakeid="9580">Ovid</providername><preferredtitle>Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="18735" authrelid="35710"><title>PsycINFO</title><providername jakeid="19225">OCLC</providername><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle><cites/></database><database jakeid="9622" authrelid="88803"><title>PUBMED</title><providername jakeid="19242">Stand Alone</providername><preferredtitle>JAMA</preferredtitle><cites/></database><database jakeid="20594" authrelid="163259"><title>Resource/One</title><providername jakeid="20577">Proquest</providername><preferredtitle>JAMA; The Journal of the American Medical Association</preferredtitle><cites><start date="1986-01-03">1/3/86</start><end>current</end></cites><fulltext><start date="1995-12-20">12/20/95</start><end>current</end></fulltext></database><database jakeid="19432" authrelid="150034"><title>Student Edition (SuperTOM)</title><providername jakeid="19406">Gale Group</providername><preferredtitle>JAMA, The Journal of the American Medical Association</preferredtitle><cites><start date="1987-01-01">1/1987</start></cites><fulltext><start date="1987-12-01">12/1987</start></fulltext></database></authrecord><titlerecord><titleinfo/><database jakeid="14603"><title>MEDLINE</title><preferredtitle>JAMA</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9627"><title>Web of Science/Science-Social-ArtsHum Citation Index</title><preferredtitle>JAMA-JOURNAL OF THE AMERICAN MEDICAL ASSOCIATION</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="11661"><title>CINAHL</title><preferredtitle>JAMA: Journal of the American Medical Association</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="1351-4164"/><database jakeid="22715"><title>Business Source Premier</title><preferredtitle>Jamaica Country Profile (EIU)</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="1351-4164"/><database jakeid="22718"><title>Corporate ResourceNet (CRN)</title><preferredtitle>Jamaica Country Profile (EIU)</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9618"><title>MLA International Bibliography</title><preferredtitle>Jamaica Jour.</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9607"><title>Handbook of Latin American Studies</title><preferredtitle>Jamaica Journal</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9606"><title>Hispanic American Periodicals Index</title><preferredtitle>Jamaica Journal</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9595"><title>CAB Abstracts</title><preferredtitle>Jamaica Journal</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9591"><title>Biosis</title><preferredtitle>Jamaica Ministry of Agriculture &amp; Fisheries Bulletin</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9591"><title>Biosis</title><preferredtitle>Jamaica Ministry of Agriculture &amp; Lands Annual Report</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9591"><title>Biosis</title><preferredtitle>Jamaica Ministry of Agriculture &amp; Lands Bulletin</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9591"><title>Biosis</title><preferredtitle>Jamaica Ministry of Agriculture Bulletin</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="9607"><title>Handbook of Latin American Studies</title><preferredtitle>Jamaican Historical Society Bulletin</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="0021-4140"/><database jakeid="9598"><title>CINAHL</title><preferredtitle>Jamaican Nurse</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="0021-4140"/><database jakeid="9617"><title>Medline</title><preferredtitle>Jamaican Nurse</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="0021-4140"/><database jakeid="9622"><title>PUBMED</title><preferredtitle>JAMAICAN NURSE</preferredtitle></database></titlerecord><titlerecord><titleinfo/><database jakeid="14603"><title>MEDLINE</title><preferredtitle>JAMAICAN NURSE</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="0175-1247"/><database jakeid="12760"><title>GeoRef</title><preferredtitle>Jamaika, Wirtschaftsdaten</preferredtitle></database></titlerecord><titlerecord><titleinfo issn="0936-0212"/><database jakeid="12760"><title>GeoRef</title><preferredtitle>Jamaika, Wirtschaftsentwicklung</preferredtitle></database></titlerecord></results></search>
"""

expected_1 = """<html><p>Your search:\n      <b>jama</b><font size="-1"> (title)</font> (21 matches)</p><table cellpadding="1" bgcolor="cccccc" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Journal of the American Medical Association</b><li type="circle"><font size="-1">jake id <b>4609</b>, type <b>serial</b>, issn <b>0098-7484</b></font></li><font size="-1"><li type="circle"> indexed by 60 databases</li><li type="circle"> fulltext in 16 databases</li></font><font size="-1"><li type="circle"><a href="http://jake.med.yale.edu/search.php3?jakeid=4609&amp;volume=&amp;issue=&amp;page=&amp;year=2000&amp;title=jama&amp;searchurl=http://jake.med.yale.edu/search.php3&amp;dataurl=http://jake.med.yale.edu/cgi-bin/getxml.pl">complete details</a></li></font></td></tr></table></td></tr></table>\n      <!-- begin jakeid=14603-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>JAMA</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=14603&amp;searchurl=http://jake.med.yale.edu/search.php3">MEDLINE</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=14603-->\n      <!-- begin jakeid=9627-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>JAMA-JOURNAL OF THE AMERICAN MEDICAL ASSOCIATION</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9627&amp;searchurl=http://jake.med.yale.edu/search.php3">Web of Science/Science-Social-ArtsHum Citation Index</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9627-->\n      <!-- begin jakeid=11661-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>JAMA: Journal of the American Medical Association</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=11661&amp;searchurl=http://jake.med.yale.edu/search.php3">CINAHL</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=11661-->\n      <!-- begin jakeid=22715-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Country Profile (EIU)</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>1351-4164</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=22715&amp;searchurl=http://jake.med.yale.edu/search.php3">Business Source Premier</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=22715-->\n      <!-- begin jakeid=22718-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Country Profile (EIU)</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>1351-4164</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=22718&amp;searchurl=http://jake.med.yale.edu/search.php3">Corporate ResourceNet (CRN)</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=22718-->\n      <!-- begin jakeid=9618-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Jour.</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9618&amp;searchurl=http://jake.med.yale.edu/search.php3">MLA International Bibliography</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9618-->\n      <!-- begin jakeid=9607-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Journal</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9607&amp;searchurl=http://jake.med.yale.edu/search.php3">Handbook of Latin American Studies</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9607-->\n      <!-- begin jakeid=9606-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Journal</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9606&amp;searchurl=http://jake.med.yale.edu/search.php3">Hispanic American Periodicals Index</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9606-->\n      <!-- begin jakeid=9595-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Journal</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9595&amp;searchurl=http://jake.med.yale.edu/search.php3">CAB Abstracts</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9595-->\n      <!-- begin jakeid=9591-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Ministry of Agriculture &amp; Fisheries Bulletin</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9591&amp;searchurl=http://jake.med.yale.edu/search.php3">Biosis</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9591-->\n      <!-- begin jakeid=9591-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Ministry of Agriculture &amp; Lands Annual Report</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9591&amp;searchurl=http://jake.med.yale.edu/search.php3">Biosis</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9591-->\n      <!-- begin jakeid=9591-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Ministry of Agriculture &amp; Lands Bulletin</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9591&amp;searchurl=http://jake.med.yale.edu/search.php3">Biosis</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9591-->\n      <!-- begin jakeid=9591-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaica Ministry of Agriculture Bulletin</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9591&amp;searchurl=http://jake.med.yale.edu/search.php3">Biosis</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9591-->\n      <!-- begin jakeid=9607-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaican Historical Society Bulletin</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9607&amp;searchurl=http://jake.med.yale.edu/search.php3">Handbook of Latin American Studies</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9607-->\n      <!-- begin jakeid=9598-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaican Nurse</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>0021-4140</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9598&amp;searchurl=http://jake.med.yale.edu/search.php3">CINAHL</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9598-->\n      <!-- begin jakeid=9617-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaican Nurse</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>0021-4140</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9617&amp;searchurl=http://jake.med.yale.edu/search.php3">Medline</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9617-->\n      <!-- begin jakeid=9622-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>JAMAICAN NURSE</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>0021-4140</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=9622&amp;searchurl=http://jake.med.yale.edu/search.php3">PUBMED</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=9622-->\n      <!-- begin jakeid=14603-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>JAMAICAN NURSE</b><li type="circle"><font size="-1">jake id -\n                </font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=14603&amp;searchurl=http://jake.med.yale.edu/search.php3">MEDLINE</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=14603-->\n      <!-- begin jakeid=12760-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaika, Wirtschaftsdaten</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>0175-1247</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=12760&amp;searchurl=http://jake.med.yale.edu/search.php3">GeoRef</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=12760-->\n      <!-- begin jakeid=12760-->\n      <table cellpadding="1" bgcolor="dddddd" border="0" cellspacing="0" width="100%"><tr><td><table cellpadding="5" bgcolor="eeeeee" border="0" cellspacing="0" width="100%"><tr><td><b>Jamaika, Wirtschaftsentwicklung</b><li type="circle"><font size="-1">jake id -\n                \n                  , issn <b>0936-0212</b></font></li><li type="circle"><font size="-1">referenced from:\n                <a href="http://jake.med.yale.edu/search.php3?jakeid=12760&amp;searchurl=http://jake.med.yale.edu/search.php3">GeoRef</a></font></li></td></tr></table></td></tr></table>\n      <!-- end jakeid=12760--></td></tr></table></html>"""

def Test(tester):
    source = test_harness.FileInfo(string=source_1)
    sheet = test_harness.FileInfo(uri='Xml/Xslt/Borrowed/dchudnov.xslt')
    test_harness.XsltTest(tester, source, [sheet], expected_1,
                          title='General XSLT features and processing time')

    return
