/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.cache.Cache;
import org.apache.lucene.util.cache.SimpleLRUCache;

final class TermInfosReader {
    private final Directory directory;
    private final String segment;
    private final FieldInfos fieldInfos;
    private final CloseableThreadLocal<ThreadResources> threadResources = new CloseableThreadLocal();
    private final SegmentTermEnum origEnum;
    private final long size;
    private final Term[] indexTerms;
    private final TermInfo[] indexInfos;
    private final long[] indexPointers;
    private final int totalIndexInterval;
    private static final int DEFAULT_CACHE_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermInfosReader(Directory dir, String seg, FieldInfos fis, int readBufferSize, int indexDivisor) throws CorruptIndexException, IOException {
        boolean success = false;
        if (indexDivisor < 1 && indexDivisor != -1) {
            throw new IllegalArgumentException("indexDivisor must be -1 (don't load terms index) or greater than 0: got " + indexDivisor);
        }
        try {
            this.directory = dir;
            this.segment = seg;
            this.fieldInfos = fis;
            this.origEnum = new SegmentTermEnum(this.directory.openInput(this.segment + "." + "tis", readBufferSize), this.fieldInfos, false);
            this.size = this.origEnum.size;
            if (indexDivisor != -1) {
                this.totalIndexInterval = this.origEnum.indexInterval * indexDivisor;
                SegmentTermEnum indexEnum = new SegmentTermEnum(this.directory.openInput(this.segment + "." + "tii", readBufferSize), this.fieldInfos, true);
                try {
                    int indexSize = 1 + ((int)indexEnum.size - 1) / indexDivisor;
                    this.indexTerms = new Term[indexSize];
                    this.indexInfos = new TermInfo[indexSize];
                    this.indexPointers = new long[indexSize];
                    int i = 0;
                    while (indexEnum.next()) {
                        this.indexTerms[i] = indexEnum.term();
                        this.indexInfos[i] = indexEnum.termInfo();
                        this.indexPointers[i] = indexEnum.indexPointer;
                        for (int j = 1; j < indexDivisor && indexEnum.next(); ++j) {
                        }
                        ++i;
                    }
                }
                finally {
                    indexEnum.close();
                }
            } else {
                this.totalIndexInterval = -1;
                this.indexTerms = null;
                this.indexInfos = null;
                this.indexPointers = null;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    public int getMaxSkipLevels() {
        return this.origEnum.maxSkipLevels;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
        this.threadResources.close();
    }

    final long size() {
        return this.size;
    }

    private ThreadResources getThreadResources() {
        ThreadResources resources = this.threadResources.get();
        if (resources == null) {
            resources = new ThreadResources();
            resources.termEnum = this.terms();
            resources.termInfoCache = new SimpleLRUCache<Term, TermInfo>(1024);
            this.threadResources.set(resources);
        }
        return resources;
    }

    private final int getIndexOffset(Term term) {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(SegmentTermEnum enumerator, int indexOffset) throws IOException {
        enumerator.seek(this.indexPointers[indexOffset], (long)indexOffset * (long)this.totalIndexInterval - 1L, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    TermInfo get(Term term) throws IOException {
        return this.get(term, true);
    }

    private TermInfo get(Term term, boolean useCache) throws IOException {
        int enumOffset;
        TermInfo ti;
        if (this.size == 0L) {
            return null;
        }
        this.ensureIndexIsRead();
        ThreadResources resources = this.getThreadResources();
        Cache<Term, TermInfo> cache = null;
        if (useCache && (ti = (cache = resources.termInfoCache).get(term)) != null) {
            return ti;
        }
        SegmentTermEnum enumerator = resources.termEnum;
        if (enumerator.term() != null && (enumerator.prev() != null && term.compareTo(enumerator.prev()) > 0 || term.compareTo(enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = (int)(enumerator.position / (long)this.totalIndexInterval) + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            int numScans = enumerator.scanTo(term);
            if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
                ti = enumerator.termInfo();
                if (cache != null && numScans > 1) {
                    cache.put(term, ti);
                }
            } else {
                ti = null;
            }
            return ti;
        }
        this.seekEnum(enumerator, this.getIndexOffset(term));
        enumerator.scanTo(term);
        if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
            ti = enumerator.termInfo();
            if (cache != null) {
                cache.put(term, ti);
            }
        } else {
            ti = null;
        }
        return ti;
    }

    private void ensureIndexIsRead() {
        if (this.indexTerms == null) {
            throw new IllegalStateException("terms index was not loaded when this reader was created");
        }
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        this.ensureIndexIsRead();
        int indexOffset = this.getIndexOffset(term);
        SegmentTermEnum enumerator = this.getThreadResources().termEnum;
        this.seekEnum(enumerator, indexOffset);
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (term.compareTo(enumerator.term()) == 0) {
            return enumerator.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term, false);
        return (SegmentTermEnum)this.getThreadResources().termEnum.clone();
    }

    private static final class ThreadResources {
        SegmentTermEnum termEnum;
        Cache<Term, TermInfo> termInfoCache;

        private ThreadResources() {
        }
    }
}

