
import os, sys

if sys.platform == 'win32':
    import jcc, _lucene
else:
    import _lucene

__dir__ = os.path.abspath(os.path.dirname(__file__))

class JavaError(Exception):
    def getJavaException(self):
        return self.args[0]
    def __str__(self):
        writer = _lucene.StringWriter()
        self.getJavaException().printStackTrace(_lucene.PrintWriter(writer))
        return "\n".join((super(JavaError, self).__str__(), "    Java stacktrace:", str(writer)))

class InvalidArgsError(Exception):
    pass

_lucene._set_exception_types(JavaError, InvalidArgsError)

VERSION = "3.0.1"
CLASSPATH = [os.path.join(__dir__, "lucene-core-3.0.1.jar"), os.path.join(__dir__, "lucene-snowball-3.0.1.jar"), os.path.join(__dir__, "lucene-analyzers-3.0.1.jar"), os.path.join(__dir__, "lucene-regex-3.0.1.jar"), os.path.join(__dir__, "lucene-memory-3.0.1.jar"), os.path.join(__dir__, "lucene-highlighter-3.0.1.jar"), os.path.join(__dir__, "lucene-queries-3.0.1.jar"), os.path.join(__dir__, "extensions.jar")]
CLASSPATH = os.pathsep.join(CLASSPATH)
_lucene.CLASSPATH = CLASSPATH
_lucene._set_function_self(_lucene.initVM, _lucene)

from _lucene import *
