
#!/usr/bin/env python
# coding: utf-8
import argparse
import json

import requests


def retrieve_group_annotations(args):

    url =  args.url

    if url is None:
        raise argparse.ArgumentTypeError('URL must be provided')

    ids = []

    params = {}
    for config_tag in ['group', 'user', 'tag', 'limit']:
        config_val = vars(args).get(config_tag)
        if config_val is not None:
            params[config_tag] = config_val

    headers = {}
    token = args.token
    if token is not None:
        headers["Authorization"] = "Bearer " + token

    res = requests.get(url, params = params, headers = headers)

    print(res.json()["total"])
    return res.json()

def save(data, path):
    with open(path, 'w') as outfile:
        json.dump(data, outfile, indent=4, separators=(',', ': '))


if __name__ == "__main__":

    parser = argparse.ArgumentParser(description='Import annotations.')

    parser.add_argument("url", type=str, help="the search url")
    parser.add_argument("--token", "-T", type=str, help="the access token")
    parser.add_argument("--group", "-g", type=str, help="filter by group")
    parser.add_argument("--user", "-u", type=str, help="filter by user")
    parser.add_argument("--tag", "-t", type=str, help="filter by tag")
    parser.add_argument("--limit", "-l", type=int, default=200, help="annoations limit")

    args = parser.parse_args()

    ids = retrieve_group_annotations(args)

    save(ids, "../assets/annotations.json")

