
import React from 'react';
import PropTypes from 'prop-types';

import { getAnnotationStyle } from '../utils';

const AnnotationQuote = ({ annotation, metacategories }) => {
  let selector = false;

  if (annotation.target[0].selector) {
    selector = annotation.target[0].selector.find(s => s.type === 'TextQuoteSelector');
  }

  if (selector) {
    return (
      <div className="exact">
        <p>
          { selector.prefix }
          <span style={getAnnotationStyle(annotation, metacategories)}>{ selector.exact }</span>
          { selector.suffix }
        </p>
      </div>
    );
  }
  return null;
};


AnnotationQuote.propTypes = {
  annotation: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
};

export default AnnotationQuote;
