import React from 'react';

import { HashRouter } from 'react-router-dom';
import { ui, layouts, pages } from 'dashboard-components';
import PropTypes from 'prop-types';

import { FormattedMessage } from 'react-intl';

import config from './config.json';

import './App.css';

const { DefaultLayoutSidebar, DefaultLayout } = layouts;
const { ScrollToTop } = ui;

const {
  DocumentsPage,
  GlossaryPage,
  ChartsPage,
  AnnotationsPage,
  TermPage,
} = pages;

const version = process.env.REACT_APP_VERSION;
const viaBaseUrl = process.env.REACT_APP_VIA_BASE_URL;
const discussionUrl = process.env.REACT_APP_DISCUSSION_URL;
const {
  metacategories,
  topics,
  documents,
  title,
  dashboardId,
} = config;

const DocumentsPageBanner = ({
  documentsMap,
  topics: topicsProp,
  metacategories: metacategoriesProp,
  viaBaseUrl: viaBaseUrlProp,
}) => (
  <DocumentsPage
    documentsMap={documentsMap}
    topics={topicsProp}
    metacategories={metacategoriesProp}
    viaBaseUrl={viaBaseUrlProp}
  >
    <div className="row">
      <h3><a className="scenarioterre-link" href={`${viaBaseUrlProp}http://scenario-terre.space/`} target="_blank" rel="noopener noreferrer"><FormattedMessage id="home.scenarioterre.welcome" defaultMessage="Annotez le site «&nbsp;Scénario Terre&nbsp;»" /></a></h3>
      <div className="scenarioterre-banner-container">
        <a className="scenarioterre-banner" href={`${viaBaseUrlProp}http://scenario-terre.space/`} target="_blank" rel="noopener noreferrer">&nbsp;</a>
      </div>
    </div>
  </DocumentsPage>
);

DocumentsPageBanner.propTypes = {
  viaBaseUrl: PropTypes.string.isRequired,
  documentsMap: PropTypes.arrayOf(PropTypes.object).isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  topics: PropTypes.arrayOf(PropTypes.string).isRequired,
};

const App = () => (
  <HashRouter>
    <ScrollToTop>
      <div>
        <DefaultLayoutSidebar
          exact
          path="/"
          component={DocumentsPageBanner}
          version={version}
          metacategories={metacategories}
          topics={topics}
          documentsMap={documents}
          viaBaseUrl={viaBaseUrl}
          title={title}
        />
        <DefaultLayout
          path="/glossary"
          component={GlossaryPage}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/charts"
          component={ChartsPage}
          metacategories={metacategories}
          topics={topics}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/annotations/:tagName?"
          component={AnnotationsPage}
          metacategories={metacategories}
          topics={topics}
          viaBaseUrl={viaBaseUrl}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/term/:term/:activeTab?/:messageId?"
          component={TermPage}
          title={title}
          viaBaseUrl={viaBaseUrl}
          metacategories={metacategories}
          topics={topics}
          version={version}
          discussionUrl={discussionUrl}
          dashboardId={dashboardId}
        />
      </div>
    </ScrollToTop>
  </HashRouter>
);

export default App;
