import React, { Component } from 'react';

import thunkMiddleware from 'redux-thunk';
import { Provider } from 'react-redux';
import { createLogger } from 'redux-logger';
import { createStore, applyMiddleware, compose } from 'redux';

import { rootReducer, actions } from 'dashboard-components';

import { dashboardId } from './config.json';

const { fetchAnnotations } = actions;

let middlewares = [thunkMiddleware];

if (process.env.NODE_ENV !== 'production') {
  const loggerMiddleware = createLogger();
  middlewares = [...middlewares, loggerMiddleware];
}

/* eslint-disable no-underscore-dangle */
const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
/* eslint-enable */

const store = createStore(
  rootReducer,
  composeEnhancers(applyMiddleware(...middlewares)),
);

export default WrappedComponent => class extends Component {
  componentWillMount() {
    const apiUrl = process.env.REACT_APP_API_URL;
    const discussionUrl = process.env.REACT_APP_DISCUSSION_URL;
    store.dispatch(fetchAnnotations(apiUrl, discussionUrl, dashboardId));
  }

  render() {
    return <Provider store={store}><WrappedComponent {...this.props} /></Provider>;
  }
};
