import React from 'react';
import PropTypes from 'prop-types';

import DocumentAnnotation from './DocumentAnnotation';

const AnnotationsList = ({ document, metacategories, categories }) => {
  const { annotations } = document;

  return annotations.map(
    annotation => (
      <DocumentAnnotation
        key={annotation.id}
        annotation={annotation}
        metacategories={metacategories}
        categories={categories}
      />
    ),
  );
};

AnnotationsList.propTypes = {
  document: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  categories: PropTypes.arrayOf(PropTypes.string).isRequired,
};


const DocumentAnnotations = ({
  document,
  metacategories,
  categories,
  viaBaseUrl,
}) => (
  <div className="card">
    <div className="card-header">
      <a href={viaBaseUrl + document.uri} target="_blank" rel="noopener noreferrer">{ document.title }</a>
    </div>

    <ul className="list-group list-group-flush small">
      <AnnotationsList
        document={document}
        metacategories={metacategories}
        categories={categories}
      />
    </ul>
  </div>
);

DocumentAnnotations.propTypes = {
  document: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  categories: PropTypes.arrayOf(PropTypes.string).isRequired,
  viaBaseUrl: PropTypes.string.isRequired,
};

export default DocumentAnnotations;
