# Annotation Dashboard

This repository contains the code for IRI annotations dashboards.
This repository contains all the instance of the dashboard and the commion components.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes. See deployment for notes on how to deploy the project on a live system.

### Prerequisites

### Prerequisites for server

- Python 3.7
- pipenv
- envrc

### Prerequisites for clientjs

- node and npm/npx

### Init env

#### ClientJS

- `cd clientjs`
- `npm install`
- `npx lerna bootstrap`
- `cp packages/annotation-dashboard-explorunivers/.env-tmpl packages/annotation-dashboard-explorunivers/.env.development`
- Edit the file `packages/annotation-dashboard-explorunivers/.env.development`
- `npx lerna run build`

### Setup dev environment

#### setup Server

##### isso
Utilise pipenv : https://github.com/pypa/pipenv

- `cd server/isso/`
- configure isso
- `cp isso.cfg.tmpl isso.cfg`
- `pipenv install`
- `pipenv run isso -c ./isso.cfg run`

##### Annotation proxy
- `cd server/sbin/`
- `cp hypothesis_proxy.conf.tmpl hypothesis_proxy.conf`
- configure proxy
- `pipenv install`
- `pipenv run python ./hypothesis_proxy.py`

#### setup client js

- `cd clientjs`
- `npm install`
- `cp packages/annotation-dashboard-explorunivers/.env-tmpl packages/annotation-dashboard-explorunivers/.env.development`
- configure .env.development file
- `npx lerna bootstrap`

##### build dashboard-components

- `cd packages/dashboard-components`
- `npm run start`

##### build annotation-dashboard-explorunivers

- `cd packages/annotation-dashboard-explorunivers`
- `npm run start`


## Create new dashboard:
- `cd annotation-dashboard/clientjs/packages`
- `npx create-react-app --use-npm <new-dashboard>`

## Deployment

The Deployment use Ansble script.
The process is described in the [deploy/README.md](deploy/README.md) file.

## Built With

* [React.js](https://reactjs.org/) - The JS framework used
* [Redux](https://redux.js.org/) - Datastore management
* [Bootstrap](https://getbootstrap.com/) - CSS Framework
* [Isso](https://posativ.org/isso/) - Used for discussion threads
* [Webpak](https://webpack.js.org/) - Js Bundler
* [Lerna](https://lernajs.io/) - Lerna for packages managements
* [Ansible](https://www.ansible.com/) - Ansible for deployment


## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/your/project/tags). 


## License

This project is licensed under the CeCILL-C - see the [LICENSE.md](LICENSE.md) file for details

## Acknowledgments

* Thank you 
