import React from 'react';
import { FormattedMessage } from 'react-intl';
import PropTypes from 'prop-types';

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

import AnnotationsDocumentsTableRow from './AnnotationsDocumentsTableRow';

const AnnotationsDocumentsTable = ({
  documents,
  viaBaseUrl,
  topics,
  metacategories,
}) => (
  <table className="table w-100">
    <thead>
      <tr>
        <th><FormattedMessage id="ui.annotations-documents-table.col.update" defaultMessage="upd." /></th>
        <th><FormattedMessage id="ui.annotations-documents-table.col.document" defaultMessage="document" /></th>
        <th><FontAwesomeIcon icon="user" /></th>
        <th><FontAwesomeIcon icon="pencil-alt" /></th>
        <th><FormattedMessage id="ui.annotations-documents-table.col.h" defaultMessage="h" /></th>
      </tr>
    </thead>
    <tbody>
      {
        documents.map(document => (
          <AnnotationsDocumentsTableRow
            key={document.uri}
            document={document}
            viaBaseUrl={viaBaseUrl}
            topics={topics}
            metacategories={metacategories}
          />
        ))
      }
    </tbody>
  </table>
);

AnnotationsDocumentsTable.propTypes = {
  documents: PropTypes.arrayOf(PropTypes.object).isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  topics: PropTypes.arrayOf(PropTypes.string).isRequired,
  viaBaseUrl: PropTypes.string.isRequired,
};

export default AnnotationsDocumentsTable;
