import React from 'react';
import PropTypes from 'prop-types';
import md5 from 'md5';

import { connect } from 'react-redux';

import IndexList from '../ui/IndexList';
import TermEntry from '../ui/TermEntry';

import './glossary.scss';

const GlossaryTerms = ({ termsDict }) => Object.keys(termsDict).sort().map((term, i) => {
  const key = `${md5(term)}-${i}`;
  return <TermEntry term={term} termDef={termsDict[term]} index={i} key={key} />;
});

GlossaryTerms.propTypes = {
  termsDict: PropTypes.object.isRequired,
};

const GlossaryPage = ({ terms }) => (
  <div className="row glossary-row">
    <IndexList terms={Object.keys(terms)} className="col col-2 glossary-cols" />

    <div className="col col-10 glossary-cols">
      <table className="glossary-table table">
        <tbody>
          <GlossaryTerms termsDict={terms} />
        </tbody>
      </table>
    </div>
  </div>
);

GlossaryPage.propTypes = {
  terms: PropTypes.object.isRequired,
};


export default connect(
  (state) => {
    const { terms } = state;
    return {
      terms,
    };
  },
)(GlossaryPage);
